/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record.chart;

import shadeio.poi.hssf.record.RecordInputStream;
import shadeio.poi.hssf.record.StandardRecord;
import shadeio.poi.util.BitField;
import shadeio.poi.util.BitFieldFactory;
import shadeio.poi.util.HexDump;
import shadeio.poi.util.LittleEndianOutput;

public final class TickRecord
extends StandardRecord {
    public static final short sid = 4126;
    private static final BitField autoTextColor = BitFieldFactory.getInstance(1);
    private static final BitField autoTextBackground = BitFieldFactory.getInstance(2);
    private static final BitField rotation = BitFieldFactory.getInstance(28);
    private static final BitField autorotate = BitFieldFactory.getInstance(32);
    private byte field_1_majorTickType;
    private byte field_2_minorTickType;
    private byte field_3_labelPosition;
    private byte field_4_background;
    private int field_5_labelColorRgb;
    private int field_6_zero1;
    private int field_7_zero2;
    private int field_8_zero3;
    private int field_9_zero4;
    private short field_10_options;
    private short field_11_tickColor;
    private short field_12_zero5;

    public TickRecord() {
    }

    public TickRecord(RecordInputStream in) {
        this.field_1_majorTickType = in.readByte();
        this.field_2_minorTickType = in.readByte();
        this.field_3_labelPosition = in.readByte();
        this.field_4_background = in.readByte();
        this.field_5_labelColorRgb = in.readInt();
        this.field_6_zero1 = in.readInt();
        this.field_7_zero2 = in.readInt();
        this.field_8_zero3 = in.readInt();
        this.field_9_zero4 = in.readInt();
        this.field_10_options = in.readShort();
        this.field_11_tickColor = in.readShort();
        this.field_12_zero5 = in.readShort();
    }

    @Override
    public String toString() {
        StringBuffer buffer = new StringBuffer();
        buffer.append("[TICK]\n");
        buffer.append("    .majorTickType        = ").append("0x").append(HexDump.toHex(this.getMajorTickType())).append(" (").append(this.getMajorTickType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .minorTickType        = ").append("0x").append(HexDump.toHex(this.getMinorTickType())).append(" (").append(this.getMinorTickType()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .labelPosition        = ").append("0x").append(HexDump.toHex(this.getLabelPosition())).append(" (").append(this.getLabelPosition()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .background           = ").append("0x").append(HexDump.toHex(this.getBackground())).append(" (").append(this.getBackground()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .labelColorRgb        = ").append("0x").append(HexDump.toHex(this.getLabelColorRgb())).append(" (").append(this.getLabelColorRgb()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero1                = ").append("0x").append(HexDump.toHex(this.getZero1())).append(" (").append(this.getZero1()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero2                = ").append("0x").append(HexDump.toHex(this.getZero2())).append(" (").append(this.getZero2()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .options              = ").append("0x").append(HexDump.toHex(this.getOptions())).append(" (").append(this.getOptions()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("         .autoTextColor            = ").append(this.isAutoTextColor()).append('\n');
        buffer.append("         .autoTextBackground       = ").append(this.isAutoTextBackground()).append('\n');
        buffer.append("         .rotation                 = ").append(this.getRotation()).append('\n');
        buffer.append("         .autorotate               = ").append(this.isAutorotate()).append('\n');
        buffer.append("    .tickColor            = ").append("0x").append(HexDump.toHex(this.getTickColor())).append(" (").append(this.getTickColor()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("    .zero3                = ").append("0x").append(HexDump.toHex(this.getZero3())).append(" (").append(this.getZero3()).append(" )");
        buffer.append(System.getProperty("line.separator"));
        buffer.append("[/TICK]\n");
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeByte(this.field_1_majorTickType);
        out.writeByte(this.field_2_minorTickType);
        out.writeByte(this.field_3_labelPosition);
        out.writeByte(this.field_4_background);
        out.writeInt(this.field_5_labelColorRgb);
        out.writeInt(this.field_6_zero1);
        out.writeInt(this.field_7_zero2);
        out.writeInt(this.field_8_zero3);
        out.writeInt(this.field_9_zero4);
        out.writeShort(this.field_10_options);
        out.writeShort(this.field_11_tickColor);
        out.writeShort(this.field_12_zero5);
    }

    @Override
    protected int getDataSize() {
        return 30;
    }

    @Override
    public short getSid() {
        return 4126;
    }

    @Override
    public Object clone() {
        TickRecord rec = new TickRecord();
        rec.field_1_majorTickType = this.field_1_majorTickType;
        rec.field_2_minorTickType = this.field_2_minorTickType;
        rec.field_3_labelPosition = this.field_3_labelPosition;
        rec.field_4_background = this.field_4_background;
        rec.field_5_labelColorRgb = this.field_5_labelColorRgb;
        rec.field_6_zero1 = this.field_6_zero1;
        rec.field_7_zero2 = this.field_7_zero2;
        rec.field_8_zero3 = this.field_8_zero3;
        rec.field_9_zero4 = this.field_9_zero4;
        rec.field_10_options = this.field_10_options;
        rec.field_11_tickColor = this.field_11_tickColor;
        rec.field_12_zero5 = this.field_12_zero5;
        return rec;
    }

    public byte getMajorTickType() {
        return this.field_1_majorTickType;
    }

    public void setMajorTickType(byte field_1_majorTickType) {
        this.field_1_majorTickType = field_1_majorTickType;
    }

    public byte getMinorTickType() {
        return this.field_2_minorTickType;
    }

    public void setMinorTickType(byte field_2_minorTickType) {
        this.field_2_minorTickType = field_2_minorTickType;
    }

    public byte getLabelPosition() {
        return this.field_3_labelPosition;
    }

    public void setLabelPosition(byte field_3_labelPosition) {
        this.field_3_labelPosition = field_3_labelPosition;
    }

    public byte getBackground() {
        return this.field_4_background;
    }

    public void setBackground(byte field_4_background) {
        this.field_4_background = field_4_background;
    }

    public int getLabelColorRgb() {
        return this.field_5_labelColorRgb;
    }

    public void setLabelColorRgb(int field_5_labelColorRgb) {
        this.field_5_labelColorRgb = field_5_labelColorRgb;
    }

    public int getZero1() {
        return this.field_6_zero1;
    }

    public void setZero1(int field_6_zero1) {
        this.field_6_zero1 = field_6_zero1;
    }

    public int getZero2() {
        return this.field_7_zero2;
    }

    public void setZero2(int field_7_zero2) {
        this.field_7_zero2 = field_7_zero2;
    }

    public short getOptions() {
        return this.field_10_options;
    }

    public void setOptions(short field_10_options) {
        this.field_10_options = field_10_options;
    }

    public short getTickColor() {
        return this.field_11_tickColor;
    }

    public void setTickColor(short field_11_tickColor) {
        this.field_11_tickColor = field_11_tickColor;
    }

    public short getZero3() {
        return this.field_12_zero5;
    }

    public void setZero3(short field_12_zero3) {
        this.field_12_zero5 = field_12_zero3;
    }

    public void setAutoTextColor(boolean value) {
        this.field_10_options = autoTextColor.setShortBoolean(this.field_10_options, value);
    }

    public boolean isAutoTextColor() {
        return autoTextColor.isSet(this.field_10_options);
    }

    public void setAutoTextBackground(boolean value) {
        this.field_10_options = autoTextBackground.setShortBoolean(this.field_10_options, value);
    }

    public boolean isAutoTextBackground() {
        return autoTextBackground.isSet(this.field_10_options);
    }

    public void setRotation(short value) {
        this.field_10_options = rotation.setShortValue(this.field_10_options, value);
    }

    public short getRotation() {
        return rotation.getShortValue(this.field_10_options);
    }

    public void setAutorotate(boolean value) {
        this.field_10_options = autorotate.setShortBoolean(this.field_10_options, value);
    }

    public boolean isAutorotate() {
        return autorotate.isSet(this.field_10_options);
    }
}

