/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.poifs.crypt.xor;

import shadeio.poi.poifs.crypt.EncryptionVerifier;
import shadeio.poi.poifs.crypt.standard.EncryptionRecord;
import shadeio.poi.util.LittleEndianByteArrayOutputStream;
import shadeio.poi.util.LittleEndianInput;

public class XOREncryptionVerifier
extends EncryptionVerifier
implements EncryptionRecord,
Cloneable {
    protected XOREncryptionVerifier() {
        this.setEncryptedKey(new byte[2]);
        this.setEncryptedVerifier(new byte[2]);
    }

    protected XOREncryptionVerifier(LittleEndianInput is) {
        byte[] key = new byte[2];
        is.readFully(key);
        this.setEncryptedKey(key);
        byte[] verifier = new byte[2];
        is.readFully(verifier);
        this.setEncryptedVerifier(verifier);
    }

    @Override
    public void write(LittleEndianByteArrayOutputStream bos) {
        bos.write(this.getEncryptedKey());
        bos.write(this.getEncryptedVerifier());
    }

    @Override
    public XOREncryptionVerifier clone() throws CloneNotSupportedException {
        return (XOREncryptionVerifier)super.clone();
    }

    @Override
    protected final void setEncryptedVerifier(byte[] encryptedVerifier) {
        super.setEncryptedVerifier(encryptedVerifier);
    }

    @Override
    protected final void setEncryptedKey(byte[] encryptedKey) {
        super.setEncryptedKey(encryptedKey);
    }
}

