/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.sl.draw;

import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Path2D;
import java.util.ArrayList;
import java.util.Collection;
import shadeio.poi.sl.draw.DrawAutoShape;
import shadeio.poi.sl.draw.Drawable;
import shadeio.poi.sl.draw.geom.Outline;
import shadeio.poi.sl.draw.geom.Path;
import shadeio.poi.sl.usermodel.AutoShape;
import shadeio.poi.sl.usermodel.FillStyle;
import shadeio.poi.sl.usermodel.FreeformShape;
import shadeio.poi.sl.usermodel.StrokeStyle;
import shadeio.poi.sl.usermodel.TextParagraph;
import shadeio.poi.sl.usermodel.TextRun;
import shadeio.poi.sl.usermodel.TextShape;

public class DrawFreeformShape
extends DrawAutoShape {
    public DrawFreeformShape(FreeformShape<?, ?> shape) {
        super((AutoShape<?, ?>)shape);
    }

    @Override
    protected Collection<Outline> computeOutlines(Graphics2D graphics) {
        ArrayList<Outline> lst = new ArrayList<Outline>();
        FreeformShape fsh = (FreeformShape)this.getShape();
        Path2D.Double sh = fsh.getPath();
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx == null) {
            tx = new AffineTransform();
        }
        Shape canvasShape = tx.createTransformedShape(sh);
        FillStyle fs = fsh.getFillStyle();
        StrokeStyle ss = fsh.getStrokeStyle();
        Path path = new Path(fs != null, ss != null);
        lst.add(new Outline(canvasShape, path));
        return lst;
    }

    @Override
    protected TextShape<?, ? extends TextParagraph<?, ?, ? extends TextRun>> getShape() {
        return (TextShape)this.shape;
    }
}

