/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.sl.draw.geom;

import java.awt.geom.Rectangle2D;
import java.util.HashMap;
import java.util.Map;
import shadeio.poi.sl.draw.geom.BuiltInGuide;
import shadeio.poi.sl.draw.geom.CustomGeometry;
import shadeio.poi.sl.draw.geom.Formula;
import shadeio.poi.sl.draw.geom.Guide;
import shadeio.poi.sl.draw.geom.IAdjustableShape;

public class Context {
    final Map<String, Double> _ctx = new HashMap<String, Double>();
    final IAdjustableShape _props;
    final Rectangle2D _anchor;

    public Context(CustomGeometry geom, Rectangle2D anchor, IAdjustableShape props) {
        this._props = props;
        this._anchor = anchor;
        for (Guide gd : geom.adjusts) {
            this.evaluate(gd);
        }
        for (Guide gd : geom.guides) {
            this.evaluate(gd);
        }
    }

    public Rectangle2D getShapeAnchor() {
        return this._anchor;
    }

    public Guide getAdjustValue(String name) {
        return this._props.getClass().getName().contains("hslf") ? null : this._props.getAdjustValue(name);
    }

    public double getValue(String key) {
        if (key.matches("(\\+|-)?\\d+")) {
            return Double.parseDouble(key);
        }
        Double val = this._ctx.get(key);
        return val != null ? val.doubleValue() : this.evaluate(BuiltInGuide.valueOf("_" + key));
    }

    public double evaluate(Formula fmla) {
        String key;
        double result = fmla.evaluate(this);
        if (fmla instanceof Guide && (key = ((Guide)fmla).getName()) != null) {
            this._ctx.put(key, result);
        }
        return result;
    }
}

