/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ss.formula.functions;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Iterator;
import shadeio.poi.ss.formula.LazyRefEval;
import shadeio.poi.ss.formula.eval.ErrorEval;
import shadeio.poi.ss.formula.eval.EvaluationException;
import shadeio.poi.ss.formula.eval.NotImplementedException;
import shadeio.poi.ss.formula.eval.NotImplementedFunctionException;
import shadeio.poi.ss.formula.eval.OperandResolver;
import shadeio.poi.ss.formula.eval.ValueEval;
import shadeio.poi.ss.formula.functions.AggregateFunction;
import shadeio.poi.ss.formula.functions.Count;
import shadeio.poi.ss.formula.functions.Counta;
import shadeio.poi.ss.formula.functions.Function;

public class Subtotal
implements Function {
    private static Function findFunction(int functionCode) throws EvaluationException {
        switch (functionCode) {
            case 1: {
                return AggregateFunction.subtotalInstance(AggregateFunction.AVERAGE);
            }
            case 2: {
                return Count.subtotalInstance();
            }
            case 3: {
                return Counta.subtotalInstance();
            }
            case 4: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MAX);
            }
            case 5: {
                return AggregateFunction.subtotalInstance(AggregateFunction.MIN);
            }
            case 6: {
                return AggregateFunction.subtotalInstance(AggregateFunction.PRODUCT);
            }
            case 7: {
                return AggregateFunction.subtotalInstance(AggregateFunction.STDEV);
            }
            case 8: {
                throw new NotImplementedFunctionException("STDEVP");
            }
            case 9: {
                return AggregateFunction.subtotalInstance(AggregateFunction.SUM);
            }
            case 10: {
                throw new NotImplementedFunctionException("VAR");
            }
            case 11: {
                throw new NotImplementedFunctionException("VARP");
            }
        }
        if (functionCode > 100 && functionCode < 112) {
            throw new NotImplementedException("SUBTOTAL - with 'exclude hidden values' option");
        }
        throw EvaluationException.invalidValue();
    }

    @Override
    public ValueEval evaluate(ValueEval[] args, int srcRowIndex, int srcColumnIndex) {
        Function innerFunc;
        int nInnerArgs = args.length - 1;
        if (nInnerArgs < 1) {
            return ErrorEval.VALUE_INVALID;
        }
        try {
            ValueEval ve = OperandResolver.getSingleValue(args[0], srcRowIndex, srcColumnIndex);
            int functionCode = OperandResolver.coerceValueToInt(ve);
            innerFunc = Subtotal.findFunction(functionCode);
        }
        catch (EvaluationException e) {
            return e.getErrorEval();
        }
        ArrayList<ValueEval> list = new ArrayList<ValueEval>(Arrays.asList(args).subList(1, args.length));
        Iterator it = list.iterator();
        while (it.hasNext()) {
            LazyRefEval lazyRefEval;
            ValueEval eval = (ValueEval)it.next();
            if (!(eval instanceof LazyRefEval) || !(lazyRefEval = (LazyRefEval)eval).isSubTotal()) continue;
            it.remove();
        }
        return innerFunc.evaluate(list.toArray(new ValueEval[list.size()]), srcRowIndex, srcColumnIndex);
    }
}

