/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xddf.usermodel.chart;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTAxDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumDataSource;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTNumVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTSerTx;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrData;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrRef;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTStrVal;
import org.openxmlformats.schemas.drawingml.x2006.chart.CTUnsignedInt;
import shadeio.poi.ss.util.CellReference;
import shadeio.poi.xddf.usermodel.XDDFShapeProperties;
import shadeio.poi.xddf.usermodel.chart.XDDFCategoryAxis;
import shadeio.poi.xddf.usermodel.chart.XDDFChartAxis;
import shadeio.poi.xddf.usermodel.chart.XDDFDataSource;
import shadeio.poi.xddf.usermodel.chart.XDDFNumericalDataSource;
import shadeio.poi.xddf.usermodel.chart.XDDFValueAxis;

public abstract class XDDFChartData {
    protected List<Series> series = new ArrayList<Series>();
    private XDDFCategoryAxis categoryAxis;
    private List<XDDFValueAxis> valueAxes;

    protected XDDFChartData() {
    }

    protected void defineAxes(CTUnsignedInt[] axes, Map<Long, XDDFChartAxis> categories, Map<Long, XDDFValueAxis> values) {
        ArrayList<XDDFValueAxis> list = new ArrayList<XDDFValueAxis>(axes.length);
        for (CTUnsignedInt axe : axes) {
            Long axisId = axe.getVal();
            XDDFChartAxis category = categories.get(axisId);
            if (category == null) {
                XDDFValueAxis axis = values.get(axisId);
                if (axis == null) continue;
                list.add(axis);
                continue;
            }
            if (!(category instanceof XDDFCategoryAxis)) continue;
            this.categoryAxis = (XDDFCategoryAxis)category;
        }
        this.valueAxes = Collections.unmodifiableList(list);
    }

    public XDDFCategoryAxis getCategoryAxis() {
        return this.categoryAxis;
    }

    public List<XDDFValueAxis> getValueAxes() {
        return this.valueAxes;
    }

    public List<Series> getSeries() {
        return this.series;
    }

    public abstract void setVaryColors(boolean var1);

    public abstract Series addSeries(XDDFDataSource<?> var1, XDDFNumericalDataSource<? extends Number> var2);

    public abstract class Series {
        protected XDDFDataSource<?> categoryData;
        protected XDDFNumericalDataSource<? extends Number> valuesData;

        protected abstract CTSerTx getSeriesText();

        public abstract void setShowLeaderLines(boolean var1);

        public abstract XDDFShapeProperties getShapeProperties();

        public abstract void setShapeProperties(XDDFShapeProperties var1);

        protected abstract CTAxDataSource getAxDS();

        protected abstract CTNumDataSource getNumDS();

        protected Series(XDDFDataSource<?> category, XDDFNumericalDataSource<? extends Number> values) {
            this.replaceData(category, values);
        }

        public void replaceData(XDDFDataSource<?> category, XDDFNumericalDataSource<? extends Number> values) {
            if (category == null || values == null) {
                throw new IllegalStateException("Category and values must be defined before filling chart data.");
            }
            int numOfPoints = category.getPointCount();
            if (numOfPoints != values.getPointCount()) {
                throw new IllegalStateException("Category and values must have the same point count.");
            }
            this.categoryData = category;
            this.valuesData = values;
        }

        public void setTitle(String title, CellReference titleRef) {
            if (titleRef == null) {
                this.getSeriesText().setV(title);
            } else {
                CTStrRef ref = this.getSeriesText().isSetStrRef() ? this.getSeriesText().getStrRef() : this.getSeriesText().addNewStrRef();
                CTStrData cache = ref.isSetStrCache() ? ref.getStrCache() : ref.addNewStrCache();
                cache.getPtArray(0).setV(title);
                ref.setF(titleRef.formatAsString());
            }
        }

        public XDDFDataSource<?> getCategoryData() {
            return this.categoryData;
        }

        public XDDFNumericalDataSource<? extends Number> getValuesData() {
            return this.valuesData;
        }

        public void plot() {
            CTNumData cache;
            int numOfPoints = this.categoryData.getPointCount();
            if (this.categoryData.isNumeric()) {
                cache = this.retrieveNumCache(this.getAxDS(), this.categoryData);
                this.fillNumCache(cache, numOfPoints, (XDDFNumericalDataSource)this.categoryData);
            } else {
                cache = this.retrieveStrCache(this.getAxDS(), this.categoryData);
                this.fillStringCache((CTStrData)cache, numOfPoints, this.categoryData);
            }
            cache = this.retrieveNumCache(this.getNumDS(), this.valuesData);
            this.fillNumCache(cache, numOfPoints, this.valuesData);
        }

        private CTNumData retrieveNumCache(CTAxDataSource axDataSource, XDDFDataSource<?> data) {
            CTNumData numCache;
            if (data.isReference()) {
                CTNumRef numRef = axDataSource.isSetNumRef() ? axDataSource.getNumRef() : axDataSource.addNewNumRef();
                numCache = numRef.isSetNumCache() ? numRef.getNumCache() : numRef.addNewNumCache();
                numRef.setF(data.getDataRangeReference());
                if (axDataSource.isSetNumLit()) {
                    axDataSource.unsetNumLit();
                }
            } else {
                numCache = axDataSource.isSetNumLit() ? axDataSource.getNumLit() : axDataSource.addNewNumLit();
                if (axDataSource.isSetNumRef()) {
                    axDataSource.unsetNumRef();
                }
            }
            return numCache;
        }

        private CTStrData retrieveStrCache(CTAxDataSource axDataSource, XDDFDataSource<?> data) {
            CTStrData strCache;
            if (data.isReference()) {
                CTStrRef strRef = axDataSource.isSetStrRef() ? axDataSource.getStrRef() : axDataSource.addNewStrRef();
                strCache = strRef.isSetStrCache() ? strRef.getStrCache() : strRef.addNewStrCache();
                strRef.setF(data.getDataRangeReference());
                if (axDataSource.isSetStrLit()) {
                    axDataSource.unsetStrLit();
                }
            } else {
                strCache = axDataSource.isSetStrLit() ? axDataSource.getStrLit() : axDataSource.addNewStrLit();
                if (axDataSource.isSetStrRef()) {
                    axDataSource.unsetStrRef();
                }
            }
            return strCache;
        }

        private CTNumData retrieveNumCache(CTNumDataSource numDataSource, XDDFDataSource<?> data) {
            CTNumData numCache;
            if (data.isReference()) {
                CTNumRef numRef = numDataSource.isSetNumRef() ? numDataSource.getNumRef() : numDataSource.addNewNumRef();
                numCache = numRef.isSetNumCache() ? numRef.getNumCache() : numRef.addNewNumCache();
                numRef.setF(data.getDataRangeReference());
                if (numDataSource.isSetNumLit()) {
                    numDataSource.unsetNumLit();
                }
            } else {
                numCache = numDataSource.isSetNumLit() ? numDataSource.getNumLit() : numDataSource.addNewNumLit();
                if (numDataSource.isSetNumRef()) {
                    numDataSource.unsetNumRef();
                }
            }
            return numCache;
        }

        private void fillStringCache(CTStrData cache, int numOfPoints, XDDFDataSource<?> data) {
            cache.setPtArray(null);
            if (cache.isSetPtCount()) {
                cache.getPtCount().setVal((long)numOfPoints);
            } else {
                cache.addNewPtCount().setVal((long)numOfPoints);
            }
            for (int i = 0; i < numOfPoints; ++i) {
                String value = data.getPointAt(i).toString();
                if (value == null) continue;
                CTStrVal ctStrVal = cache.addNewPt();
                ctStrVal.setIdx((long)i);
                ctStrVal.setV(value);
            }
        }

        private void fillNumCache(CTNumData cache, int numOfPoints, XDDFNumericalDataSource<?> data) {
            String formatCode = data.getFormatCode();
            if (formatCode == null) {
                if (cache.isSetFormatCode()) {
                    cache.unsetFormatCode();
                }
            } else {
                cache.setFormatCode(formatCode);
            }
            cache.setPtArray(null);
            if (cache.isSetPtCount()) {
                cache.getPtCount().setVal((long)numOfPoints);
            } else {
                cache.addNewPtCount().setVal((long)numOfPoints);
            }
            for (int i = 0; i < numOfPoints; ++i) {
                Object value = data.getPointAt(i);
                if (value == null) continue;
                CTNumVal ctNumVal = cache.addNewPt();
                ctNumVal.setIdx((long)i);
                ctNumVal.setV(value.toString());
            }
        }
    }
}

