/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xdgf.usermodel;

import com.microsoft.schemas.office.visio.x2012.main.VisioDocumentDocument1;
import com.microsoft.schemas.office.visio.x2012.main.VisioDocumentType;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import shadeio.poi.ooxml.POIXMLDocument;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.ooxml.util.PackageHelper;
import shadeio.poi.openxml4j.opc.OPCPackage;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.xdgf.usermodel.XDGFDocument;
import shadeio.poi.xdgf.usermodel.XDGFFactory;
import shadeio.poi.xdgf.usermodel.XDGFMasters;
import shadeio.poi.xdgf.usermodel.XDGFPage;
import shadeio.poi.xdgf.usermodel.XDGFPages;
import shadeio.poi.xdgf.usermodel.XDGFStyleSheet;

public class XmlVisioDocument
extends POIXMLDocument {
    protected XDGFPages _pages;
    protected XDGFMasters _masters;
    protected XDGFDocument _document;

    public XmlVisioDocument(OPCPackage pkg) throws IOException {
        super(pkg, "http://schemas.microsoft.com/visio/2010/relationships/document");
        VisioDocumentType document;
        try {
            document = VisioDocumentDocument1.Factory.parse((InputStream)this.getPackagePart().getInputStream()).getVisioDocument();
        }
        catch (IOException | XmlException e) {
            throw new POIXMLException(e);
        }
        this._document = new XDGFDocument(document);
        this.load(new XDGFFactory(this._document));
    }

    public XmlVisioDocument(InputStream is) throws IOException {
        this(PackageHelper.open(is));
    }

    @Override
    protected void onDocumentRead() {
        for (POIXMLDocumentPart part : this.getRelations()) {
            if (part instanceof XDGFPages) {
                this._pages = (XDGFPages)part;
                continue;
            }
            if (!(part instanceof XDGFMasters)) continue;
            this._masters = (XDGFMasters)part;
        }
        if (this._masters != null) {
            this._masters.onDocumentRead();
        }
        this._pages.onDocumentRead();
    }

    @Override
    public List<PackagePart> getAllEmbeddedParts() {
        return new ArrayList<PackagePart>();
    }

    public Collection<XDGFPage> getPages() {
        return this._pages.getPageList();
    }

    public XDGFStyleSheet getStyleById(long id) {
        return this._document.getStyleById(id);
    }
}

