/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xslf.usermodel;

import java.awt.Color;
import org.apache.xmlbeans.XmlObject;
import org.openxmlformats.schemas.drawingml.x2006.main.CTColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTFontReference;
import org.openxmlformats.schemas.drawingml.x2006.main.CTHslColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPositiveFixedPercentage;
import org.openxmlformats.schemas.drawingml.x2006.main.CTPresetColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTScRgbColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSchemeColor;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSolidColorFillProperties;
import org.openxmlformats.schemas.drawingml.x2006.main.CTSystemColor;
import org.w3c.dom.Node;
import shadeio.poi.sl.draw.DrawPaint;
import shadeio.poi.sl.usermodel.AbstractColorStyle;
import shadeio.poi.sl.usermodel.ColorStyle;
import shadeio.poi.sl.usermodel.PresetColor;
import shadeio.poi.util.Internal;
import shadeio.poi.util.POILogFactory;
import shadeio.poi.util.POILogger;
import shadeio.poi.xslf.usermodel.XSLFTheme;

@Internal
public class XSLFColor {
    private static final POILogger LOGGER = POILogFactory.getLogger(XSLFColor.class);
    private XmlObject _xmlObject;
    private Color _color;
    private CTSchemeColor _phClr;

    public XSLFColor(XmlObject obj, XSLFTheme theme, CTSchemeColor phClr) {
        this._xmlObject = obj;
        this._phClr = phClr;
        this._color = this.toColor(obj, theme);
    }

    @Internal
    public XmlObject getXmlObject() {
        return this._xmlObject;
    }

    public Color getColor() {
        return DrawPaint.applyColorTransform(this.getColorStyle());
    }

    public ColorStyle getColorStyle() {
        return new AbstractColorStyle(){

            @Override
            public Color getColor() {
                return XSLFColor.this._color;
            }

            @Override
            public int getAlpha() {
                return XSLFColor.this.getRawValue("alpha");
            }

            @Override
            public int getHueOff() {
                return XSLFColor.this.getRawValue("hueOff");
            }

            @Override
            public int getHueMod() {
                return XSLFColor.this.getRawValue("hueMod");
            }

            @Override
            public int getSatOff() {
                return XSLFColor.this.getRawValue("satOff");
            }

            @Override
            public int getSatMod() {
                return XSLFColor.this.getRawValue("satMod");
            }

            @Override
            public int getLumOff() {
                return XSLFColor.this.getRawValue("lumOff");
            }

            @Override
            public int getLumMod() {
                return XSLFColor.this.getRawValue("lumMod");
            }

            @Override
            public int getShade() {
                return XSLFColor.this.getRawValue("shade");
            }

            @Override
            public int getTint() {
                return XSLFColor.this.getRawValue("tint");
            }
        };
    }

    private Color toColor(XmlObject obj, XSLFTheme theme) {
        Color color = null;
        for (XmlObject ch : obj.selectPath("*")) {
            if (ch instanceof CTHslColor) {
                CTHslColor hsl = (CTHslColor)ch;
                int h = hsl.getHue2();
                int s = hsl.getSat2();
                int l = hsl.getLum2();
                color = DrawPaint.HSL2RGB((double)h / 60000.0, (double)s / 1000.0, (double)l / 1000.0, 1.0);
                continue;
            }
            if (ch instanceof CTPresetColor) {
                CTPresetColor prst = (CTPresetColor)ch;
                String colorName = prst.getVal().toString();
                PresetColor pc = PresetColor.valueOfOoxmlId(colorName);
                if (pc == null) continue;
                color = pc.color;
                continue;
            }
            if (ch instanceof CTSchemeColor) {
                CTColor ctColor;
                CTSchemeColor schemeColor = (CTSchemeColor)ch;
                String colorRef = schemeColor.getVal().toString();
                if (this._phClr != null) {
                    colorRef = this._phClr.getVal().toString();
                }
                if ((ctColor = theme.getCTColor(colorRef)) == null) continue;
                color = this.toColor((XmlObject)ctColor, null);
                continue;
            }
            if (ch instanceof CTScRgbColor) {
                CTScRgbColor scrgb = (CTScRgbColor)ch;
                color = new Color(DrawPaint.lin2srgb(scrgb.getR()), DrawPaint.lin2srgb(scrgb.getG()), DrawPaint.lin2srgb(scrgb.getB()));
                continue;
            }
            if (ch instanceof CTSRgbColor) {
                CTSRgbColor srgb = (CTSRgbColor)ch;
                byte[] val = srgb.getVal();
                color = new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
                continue;
            }
            if (ch instanceof CTSystemColor) {
                CTSystemColor sys = (CTSystemColor)ch;
                if (sys.isSetLastClr()) {
                    byte[] val = sys.getLastClr();
                    color = new Color(0xFF & val[0], 0xFF & val[1], 0xFF & val[2]);
                    continue;
                }
                String colorName = sys.getVal().toString();
                PresetColor pc = PresetColor.valueOfOoxmlId(colorName);
                if (pc != null) {
                    color = pc.color;
                }
                if (color != null) continue;
                color = Color.black;
                continue;
            }
            if (ch instanceof CTFontReference) continue;
            throw new IllegalArgumentException("Unexpected color choice: " + ch.getClass());
        }
        return color;
    }

    @Internal
    protected void setColor(Color color) {
        CTPositiveFixedPercentage alphaPct;
        float[] rgbaf;
        boolean addAlpha;
        if (!(this._xmlObject instanceof CTSolidColorFillProperties)) {
            LOGGER.log(7, "XSLFColor.setColor currently only supports CTSolidColorFillProperties");
            return;
        }
        CTSolidColorFillProperties fill = (CTSolidColorFillProperties)this._xmlObject;
        if (fill.isSetSrgbClr()) {
            fill.unsetSrgbClr();
        }
        if (fill.isSetScrgbClr()) {
            fill.unsetScrgbClr();
        }
        if (fill.isSetHslClr()) {
            fill.unsetHslClr();
        }
        if (fill.isSetPrstClr()) {
            fill.unsetPrstClr();
        }
        if (fill.isSetSchemeClr()) {
            fill.unsetSchemeClr();
        }
        if (fill.isSetSysClr()) {
            fill.unsetSysClr();
        }
        boolean bl = addAlpha = (rgbaf = color.getRGBComponents(null)).length == 4 && rgbaf[3] < 1.0f;
        if (XSLFColor.isInt(rgbaf[0]) && XSLFColor.isInt(rgbaf[1]) && XSLFColor.isInt(rgbaf[2])) {
            CTSRgbColor rgb = fill.addNewSrgbClr();
            byte[] rgbBytes = new byte[]{(byte)color.getRed(), (byte)color.getGreen(), (byte)color.getBlue()};
            rgb.setVal(rgbBytes);
            alphaPct = addAlpha ? rgb.addNewAlpha() : null;
        } else {
            CTScRgbColor rgb = fill.addNewScrgbClr();
            rgb.setR(DrawPaint.srgb2lin(rgbaf[0]));
            rgb.setG(DrawPaint.srgb2lin(rgbaf[1]));
            rgb.setB(DrawPaint.srgb2lin(rgbaf[2]));
            CTPositiveFixedPercentage cTPositiveFixedPercentage = alphaPct = addAlpha ? rgb.addNewAlpha() : null;
        }
        if (alphaPct != null) {
            alphaPct.setVal((int)(100000.0f * rgbaf[3]));
        }
    }

    private static boolean isInt(float f) {
        return Math.abs((double)(f * 255.0f) - Math.rint(f * 255.0f)) < (double)1.0E-5f;
    }

    private int getRawValue(String elem) {
        Node attr;
        XmlObject[] obj;
        String query = "declare namespace a='http://schemas.openxmlformats.org/drawingml/2006/main' $this//a:" + elem;
        if (this._phClr != null && (obj = this._phClr.selectPath(query)).length == 1 && (attr = obj[0].getDomNode().getAttributes().getNamedItem("val")) != null) {
            return Integer.parseInt(attr.getNodeValue());
        }
        obj = this._xmlObject.selectPath(query);
        if (obj.length == 1 && (attr = obj[0].getDomNode().getAttributes().getNamedItem("val")) != null) {
            return Integer.parseInt(attr.getNodeValue());
        }
        return -1;
    }

    private int getPercentageValue(String elem) {
        int val = this.getRawValue(elem);
        return val == -1 ? val : val / 1000;
    }

    int getAlpha() {
        return this.getPercentageValue("alpha");
    }

    int getAlphaMod() {
        return this.getPercentageValue("alphaMod");
    }

    int getAlphaOff() {
        return this.getPercentageValue("alphaOff");
    }

    int getHue() {
        int val = this.getRawValue("hue");
        return val == -1 ? val : val / 60000;
    }

    int getHueMod() {
        return this.getPercentageValue("hueMod");
    }

    int getHueOff() {
        return this.getPercentageValue("hueOff");
    }

    int getLum() {
        return this.getPercentageValue("lum");
    }

    int getLumMod() {
        return this.getPercentageValue("lumMod");
    }

    int getLumOff() {
        return this.getPercentageValue("lumOff");
    }

    int getSat() {
        return this.getPercentageValue("sat");
    }

    int getSatMod() {
        return this.getPercentageValue("satMod");
    }

    int getSatOff() {
        return this.getPercentageValue("satOff");
    }

    int getRed() {
        return this.getPercentageValue("red");
    }

    int getRedMod() {
        return this.getPercentageValue("redMod");
    }

    int getRedOff() {
        return this.getPercentageValue("redOff");
    }

    int getGreen() {
        return this.getPercentageValue("green");
    }

    int getGreenMod() {
        return this.getPercentageValue("greenMod");
    }

    int getGreenOff() {
        return this.getPercentageValue("greenOff");
    }

    int getBlue() {
        return this.getPercentageValue("blue");
    }

    int getBlueMod() {
        return this.getPercentageValue("blueMod");
    }

    int getBlueOff() {
        return this.getPercentageValue("blueOff");
    }

    public int getShade() {
        return this.getPercentageValue("shade");
    }

    public int getTint() {
        return this.getPercentageValue("tint");
    }
}

