/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import shadeio.poi.ss.formula.BaseFormulaEvaluator;
import shadeio.poi.ss.formula.EvaluationCell;
import shadeio.poi.ss.formula.WorkbookEvaluator;
import shadeio.poi.ss.formula.eval.BoolEval;
import shadeio.poi.ss.formula.eval.ErrorEval;
import shadeio.poi.ss.formula.eval.NumberEval;
import shadeio.poi.ss.formula.eval.StringEval;
import shadeio.poi.ss.formula.eval.ValueEval;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellValue;
import shadeio.poi.ss.usermodel.RichTextString;
import shadeio.poi.xssf.usermodel.XSSFRichTextString;

public abstract class BaseXSSFFormulaEvaluator
extends BaseFormulaEvaluator {
    protected BaseXSSFFormulaEvaluator(WorkbookEvaluator bookEvaluator) {
        super(bookEvaluator);
    }

    @Override
    protected RichTextString createRichTextString(String str) {
        return new XSSFRichTextString(str);
    }

    protected abstract EvaluationCell toEvaluationCell(Cell var1);

    @Override
    protected CellValue evaluateFormulaCellValue(Cell cell) {
        EvaluationCell evalCell = this.toEvaluationCell(cell);
        ValueEval eval = this._bookEvaluator.evaluate(evalCell);
        if (eval instanceof NumberEval) {
            NumberEval ne = (NumberEval)eval;
            return new CellValue(ne.getNumberValue());
        }
        if (eval instanceof BoolEval) {
            BoolEval be = (BoolEval)eval;
            return CellValue.valueOf(be.getBooleanValue());
        }
        if (eval instanceof StringEval) {
            StringEval ne = (StringEval)eval;
            return new CellValue(ne.getStringValue());
        }
        if (eval instanceof ErrorEval) {
            return CellValue.getError(((ErrorEval)eval).getErrorCode());
        }
        throw new RuntimeException("Unexpected eval class (" + eval.getClass().getName() + ")");
    }
}

