/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel.helpers;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTCellFormula;
import shadeio.poi.ss.formula.FormulaParser;
import shadeio.poi.ss.formula.FormulaRenderer;
import shadeio.poi.ss.formula.FormulaType;
import shadeio.poi.ss.formula.ptg.Ptg;
import shadeio.poi.ss.formula.ptg.Pxg;
import shadeio.poi.ss.formula.ptg.Pxg3D;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.ss.usermodel.Row;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.xssf.usermodel.XSSFCell;
import shadeio.poi.xssf.usermodel.XSSFEvaluationWorkbook;
import shadeio.poi.xssf.usermodel.XSSFName;
import shadeio.poi.xssf.usermodel.XSSFWorkbook;

public final class XSSFFormulaUtils {
    private final XSSFWorkbook _wb;
    private final XSSFEvaluationWorkbook _fpwb;

    public XSSFFormulaUtils(XSSFWorkbook wb) {
        this._wb = wb;
        this._fpwb = XSSFEvaluationWorkbook.create(this._wb);
    }

    public void updateSheetName(int sheetIndex, String oldName, String newName) {
        for (XSSFName nm : this._wb.getAllNames()) {
            if (nm.getSheetIndex() != -1 && nm.getSheetIndex() != sheetIndex) continue;
            this.updateName(nm, oldName, newName);
        }
        for (Sheet sh : this._wb) {
            for (Row row : sh) {
                for (Cell cell : row) {
                    if (cell.getCellType() != CellType.FORMULA) continue;
                    this.updateFormula((XSSFCell)cell, oldName, newName);
                }
            }
        }
    }

    private void updateFormula(XSSFCell cell, String oldName, String newName) {
        String formula;
        CTCellFormula f = cell.getCTCell().getF();
        if (f != null && (formula = f.getStringValue()) != null && formula.length() > 0) {
            Ptg[] ptgs;
            int sheetIndex = this._wb.getSheetIndex(cell.getSheet());
            for (Ptg ptg : ptgs = FormulaParser.parse(formula, this._fpwb, FormulaType.CELL, sheetIndex, cell.getRowIndex())) {
                this.updatePtg(ptg, oldName, newName);
            }
            String updatedFormula = FormulaRenderer.toFormulaString(this._fpwb, ptgs);
            if (!formula.equals(updatedFormula)) {
                f.setStringValue(updatedFormula);
            }
        }
    }

    private void updateName(XSSFName name, String oldName, String newName) {
        String formula = name.getRefersToFormula();
        if (formula != null) {
            Ptg[] ptgs;
            int sheetIndex = name.getSheetIndex();
            int rowIndex = -1;
            for (Ptg ptg : ptgs = FormulaParser.parse(formula, this._fpwb, FormulaType.NAMEDRANGE, sheetIndex, rowIndex)) {
                this.updatePtg(ptg, oldName, newName);
            }
            String updatedFormula = FormulaRenderer.toFormulaString(this._fpwb, ptgs);
            if (!formula.equals(updatedFormula)) {
                name.setRefersToFormula(updatedFormula);
            }
        }
    }

    private void updatePtg(Ptg ptg, String oldName, String newName) {
        Pxg pxg;
        if (ptg instanceof Pxg && (pxg = (Pxg)((Object)ptg)).getExternalWorkbookNumber() < 1) {
            Pxg3D pxg3D;
            if (pxg.getSheetName() != null && pxg.getSheetName().equals(oldName)) {
                pxg.setSheetName(newName);
            }
            if (pxg instanceof Pxg3D && (pxg3D = (Pxg3D)pxg).getLastSheetName() != null && pxg3D.getLastSheetName().equals(oldName)) {
                pxg3D.setLastSheetName(newName);
            }
        }
    }
}

