/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.ss.formula.functions;

import shadeio.poi.ss.formula.eval.ErrorEval;
import shadeio.poi.ss.formula.eval.EvaluationException;
import shadeio.poi.ss.formula.eval.NumberEval;
import shadeio.poi.ss.formula.eval.OperandResolver;
import shadeio.poi.ss.formula.eval.ValueEval;
import shadeio.poi.ss.formula.functions.Fixed1ArgFunction;
import shadeio.poi.ss.usermodel.FormulaError;

public final class Errortype
extends Fixed1ArgFunction {
    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval arg0) {
        try {
            OperandResolver.getSingleValue(arg0, srcRowIndex, srcColumnIndex);
            return ErrorEval.NA;
        }
        catch (EvaluationException e) {
            int result = this.translateErrorCodeToErrorTypeValue(e.getErrorEval().getErrorCode());
            return new NumberEval(result);
        }
    }

    private int translateErrorCodeToErrorTypeValue(int errorCode) {
        switch (FormulaError.forInt(errorCode)) {
            case NULL: {
                return 1;
            }
            case DIV0: {
                return 2;
            }
            case VALUE: {
                return 3;
            }
            case REF: {
                return 4;
            }
            case NAME: {
                return 5;
            }
            case NUM: {
                return 6;
            }
            case NA: {
                return 7;
            }
        }
        throw new IllegalArgumentException("Invalid error code (" + errorCode + ")");
    }
}

