/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import org.openxmlformats.schemas.spreadsheetml.x2006.main.CTColor;
import shadeio.poi.common.usermodel.HyperlinkType;
import shadeio.poi.ss.usermodel.CreationHelper;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.CellReference;
import shadeio.poi.util.Internal;
import shadeio.poi.xssf.usermodel.XSSFClientAnchor;
import shadeio.poi.xssf.usermodel.XSSFColor;
import shadeio.poi.xssf.usermodel.XSSFDataFormat;
import shadeio.poi.xssf.usermodel.XSSFFormulaEvaluator;
import shadeio.poi.xssf.usermodel.XSSFHyperlink;
import shadeio.poi.xssf.usermodel.XSSFRichTextString;
import shadeio.poi.xssf.usermodel.XSSFWorkbook;

public class XSSFCreationHelper
implements CreationHelper {
    private final XSSFWorkbook workbook;

    @Internal
    public XSSFCreationHelper(XSSFWorkbook wb) {
        this.workbook = wb;
    }

    @Override
    public XSSFRichTextString createRichTextString(String text) {
        XSSFRichTextString rt = new XSSFRichTextString(text);
        rt.setStylesTableReference(this.workbook.getStylesSource());
        return rt;
    }

    @Override
    public XSSFDataFormat createDataFormat() {
        return this.workbook.createDataFormat();
    }

    @Override
    public XSSFColor createExtendedColor() {
        return XSSFColor.from(CTColor.Factory.newInstance(), this.workbook.getStylesSource().getIndexedColors());
    }

    @Override
    public XSSFHyperlink createHyperlink(HyperlinkType type) {
        return new XSSFHyperlink(type);
    }

    @Override
    public XSSFFormulaEvaluator createFormulaEvaluator() {
        return new XSSFFormulaEvaluator(this.workbook);
    }

    @Override
    public XSSFClientAnchor createClientAnchor() {
        return new XSSFClientAnchor();
    }

    @Override
    public AreaReference createAreaReference(String reference) {
        return new AreaReference(reference, this.workbook.getSpreadsheetVersion());
    }

    @Override
    public AreaReference createAreaReference(CellReference topLeft, CellReference bottomRight) {
        return new AreaReference(topLeft, bottomRight, this.workbook.getSpreadsheetVersion());
    }
}

