/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xwpf.usermodel;

import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTSdtPr;
import org.openxmlformats.schemas.wordprocessingml.x2006.main.CTString;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.xwpf.usermodel.BodyElementType;
import shadeio.poi.xwpf.usermodel.BodyType;
import shadeio.poi.xwpf.usermodel.IBody;
import shadeio.poi.xwpf.usermodel.ISDTContent;
import shadeio.poi.xwpf.usermodel.ISDTContents;
import shadeio.poi.xwpf.usermodel.XWPFDocument;

public abstract class XWPFAbstractSDT
implements ISDTContents {
    private final String title;
    private final String tag;
    private final IBody part;

    public XWPFAbstractSDT(CTSdtPr pr, IBody part) {
        if (pr == null) {
            this.title = "";
            this.tag = "";
        } else {
            CTString[] aliases = pr.getAliasArray();
            this.title = aliases != null && aliases.length > 0 ? aliases[0].getVal() : "";
            CTString[] tags = pr.getTagArray();
            this.tag = tags != null && tags.length > 0 ? tags[0].getVal() : "";
        }
        this.part = part;
    }

    public String getTitle() {
        return this.title;
    }

    public String getTag() {
        return this.tag;
    }

    public abstract ISDTContent getContent();

    public IBody getBody() {
        return null;
    }

    public POIXMLDocumentPart getPart() {
        return this.part.getPart();
    }

    public BodyType getPartType() {
        return BodyType.CONTENTCONTROL;
    }

    public BodyElementType getElementType() {
        return BodyElementType.CONTENTCONTROL;
    }

    public XWPFDocument getDocument() {
        return this.part.getXWPFDocument();
    }
}

