/*
 * Decompiled with CFR 0.152.
 */
package shadeio.spoiwo.natures.csv;

import java.time.ZoneId;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Serializable;
import scala.StringContext;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.Seq;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import shadeio.spoiwo.model.BlankCell;
import shadeio.spoiwo.model.BooleanCell;
import shadeio.spoiwo.model.CalendarCell;
import shadeio.spoiwo.model.Cell;
import shadeio.spoiwo.model.DateCell;
import shadeio.spoiwo.model.HyperLinkUrlCell;
import shadeio.spoiwo.model.NumericCell;
import shadeio.spoiwo.model.Row;
import shadeio.spoiwo.model.Sheet;
import shadeio.spoiwo.model.StringCell;
import shadeio.spoiwo.model.Workbook;
import shadeio.spoiwo.natures.csv.CsvProperties;
import shadeio.spoiwo.natures.csv.Model2CsvConversions;

public final class Model2CsvConversions$ {
    public static final Model2CsvConversions$ MODULE$;

    static {
        new Model2CsvConversions$();
    }

    public Model2CsvConversions.CsvWorkbook CsvWorkbook(Workbook wb) {
        return new Model2CsvConversions.CsvWorkbook(wb);
    }

    public Model2CsvConversions.CsvSheet CsvSheet(Sheet s) {
        return new Model2CsvConversions.CsvSheet(s);
    }

    public Map<String, String> com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertWorkbookToCsv(Workbook wb, CsvProperties properties) {
        Predef$.MODULE$.require(wb.sheets().size() <= 1 || wb.sheets().forall((Function1)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final boolean apply(Sheet x$1) {
                return x$1.name().isDefined();
            }
        }), (Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "When converting workbook with multiple sheets to CSV format it is required to specify the unique name for each of them!";
            }
        });
        return ((TraversableOnce)wb.sheets().map((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final CsvProperties properties$1;

            public final Tuple2<String, String> apply(Sheet s) {
                return Model2CsvConversions$.MODULE$.com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertSheetToCsv(s, this.properties$1);
            }
            {
                this.properties$1 = properties$1;
            }
        }, Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<String, String> com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertSheetToCsv(Sheet s, CsvProperties properties) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s.name().getOrElse((Function0)new Serializable(){
            public static final long serialVersionUID = 0L;

            public final String apply() {
                return "";
            }
        })), (Object)((TraversableOnce)s.rows().map((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final CsvProperties properties$2;

            public final String apply(Row r) {
                return Model2CsvConversions$.MODULE$.com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertRowToCsv(r, this.properties$2);
            }
            {
                this.properties$2 = properties$2;
            }
        }, List$.MODULE$.canBuildFrom())).mkString("\n"));
    }

    public String com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertRowToCsv(Row r, CsvProperties properties) {
        return ((TraversableOnce)r.cells().map((Function1)new Serializable(properties){
            public static final long serialVersionUID = 0L;
            private final CsvProperties properties$3;

            public final String apply(Cell c) {
                return Model2CsvConversions$.MODULE$.com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertCellToCsv(c, this.properties$3);
            }
            {
                this.properties$3 = properties$3;
            }
        }, Iterable$.MODULE$.canBuildFrom())).mkString(properties.separator());
    }

    public String com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertCellToCsv(Cell c, CsvProperties properties) {
        Cell cell;
        block9: {
            String string;
            block3: {
                block8: {
                    block7: {
                        block6: {
                            block5: {
                                block4: {
                                    block2: {
                                        cell = c;
                                        if (!(cell instanceof BlankCell)) break block2;
                                        string = "";
                                        break block3;
                                    }
                                    if (!(cell instanceof StringCell)) break block4;
                                    StringCell stringCell = (StringCell)cell;
                                    string = stringCell.value();
                                    break block3;
                                }
                                if (!(cell instanceof NumericCell)) break block5;
                                NumericCell numericCell = (NumericCell)cell;
                                string = ((Object)BoxesRunTime.boxToDouble((double)numericCell.value())).toString();
                                break block3;
                            }
                            if (!(cell instanceof BooleanCell)) break block6;
                            BooleanCell booleanCell = (BooleanCell)cell;
                            string = booleanCell.value() ? properties.defaultBooleanTrueString() : properties.defaultBooleanFalseString();
                            break block3;
                        }
                        if (!(cell instanceof DateCell)) break block7;
                        DateCell dateCell = (DateCell)cell;
                        string = dateCell.value().toInstant().atZone(ZoneId.systemDefault()).format(properties.defaultDateFormatter());
                        break block3;
                    }
                    if (!(cell instanceof CalendarCell)) break block8;
                    CalendarCell calendarCell = (CalendarCell)cell;
                    string = calendarCell.value().toInstant().atZone(ZoneId.systemDefault()).format(properties.defaultDateFormatter());
                    break block3;
                }
                if (!(cell instanceof HyperLinkUrlCell)) break block9;
                HyperLinkUrlCell hyperLinkUrlCell = (HyperLinkUrlCell)cell;
                string = hyperLinkUrlCell.value().text();
            }
            return string;
        }
        throw new IllegalArgumentException(new StringContext((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"Unable to convert to CSV cell for value: ", "!"})).s((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{cell})));
    }

    private Model2CsvConversions$() {
        MODULE$ = this;
    }
}

