/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.impl;

import com.monitorjbl.xlsx.exceptions.MissingSheetException;
import com.monitorjbl.xlsx.impl.StreamingSheet;
import com.monitorjbl.xlsx.impl.StreamingWorkbookReader;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ss.SpreadsheetVersion;
import org.apache.poi.ss.formula.udf.UDFFinder;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.DataFormat;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.Name;
import org.apache.poi.ss.usermodel.PictureData;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.SheetVisibility;
import org.apache.poi.ss.usermodel.Workbook;

public class StreamingWorkbook
implements Workbook,
AutoCloseable {
    private final StreamingWorkbookReader reader;

    public StreamingWorkbook(StreamingWorkbookReader reader) {
        this.reader = reader;
    }

    int findSheetByName(String name) {
        for (int i = 0; i < this.reader.getSheetProperties().size(); ++i) {
            if (!this.reader.getSheetProperties().get(i).get("name").equals(name)) continue;
            return i;
        }
        return -1;
    }

    @Override
    public Iterator<Sheet> iterator() {
        return this.reader.iterator();
    }

    @Override
    public Iterator<Sheet> sheetIterator() {
        return this.iterator();
    }

    @Override
    public String getSheetName(int sheet) {
        return this.reader.getSheetProperties().get(sheet).get("name");
    }

    @Override
    public int getSheetIndex(String name) {
        return this.findSheetByName(name);
    }

    @Override
    public int getSheetIndex(Sheet sheet) {
        if (sheet instanceof StreamingSheet) {
            return this.findSheetByName(sheet.getSheetName());
        }
        throw new UnsupportedOperationException("Cannot use non-StreamingSheet sheets");
    }

    @Override
    public int getNumberOfSheets() {
        return this.reader.getSheets().size();
    }

    @Override
    public Sheet getSheetAt(int index) {
        return this.reader.getSheets().get(index);
    }

    @Override
    public Sheet getSheet(String name) {
        int index = this.getSheetIndex(name);
        if (index == -1) {
            throw new MissingSheetException("Sheet '" + name + "' does not exist");
        }
        return this.reader.getSheets().get(index);
    }

    @Override
    public boolean isSheetHidden(int sheetIx) {
        return "hidden".equals(this.reader.getSheetProperties().get(sheetIx).get("state"));
    }

    @Override
    public boolean isSheetVeryHidden(int sheetIx) {
        return "veryHidden".equals(this.reader.getSheetProperties().get(sheetIx).get("state"));
    }

    @Override
    public void close() {
        this.reader.close();
    }

    @Override
    public int getActiveSheetIndex() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setActiveSheet(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getFirstVisibleTab() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setFirstVisibleTab(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetOrder(String sheetname, int pos) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSelectedTab(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetName(int sheet, String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet createSheet() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet createSheet(String sheetname) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Sheet cloneSheet(int sheetNum) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeSheetAt(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font createFont() {
        throw new UnsupportedOperationException();
    }

    public Font findFont(short boldWeight, short color, short fontHeight, String name, boolean italic, boolean strikeout, short typeOffset, byte underline) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font findFont(boolean b, short i, short i1, String s2, boolean b1, boolean b2, short i2, byte b3) {
        throw new UnsupportedOperationException();
    }

    @Override
    public short getNumberOfFonts() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Font getFontAt(short idx) {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellStyle createCellStyle() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumCellStyles() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CellStyle getCellStyleAt(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void write(OutputStream stream) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNumberOfNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name getName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends Name> getNames(String s2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends Name> getAllNames() {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name getNameAt(int nameIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Name createName() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int getNameIndex(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(int index) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(String name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removeName(Name name) {
        throw new UnsupportedOperationException();
    }

    @Override
    public int linkExternalWorkbook(String name, Workbook workbook) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintArea(int sheetIndex, String reference) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setPrintArea(int sheetIndex, int startColumn, int endColumn, int startRow, int endRow) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getPrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void removePrintArea(int sheetIndex) {
        throw new UnsupportedOperationException();
    }

    @Override
    public Row.MissingCellPolicy getMissingCellPolicy() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setMissingCellPolicy(Row.MissingCellPolicy missingCellPolicy) {
        throw new UnsupportedOperationException();
    }

    @Override
    public DataFormat createDataFormat() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addPicture(byte[] pictureData, int format2) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List<? extends PictureData> getAllPictures() {
        throw new UnsupportedOperationException();
    }

    @Override
    public CreationHelper getCreationHelper() {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isHidden() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setHidden(boolean hiddenFlag) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetHidden(int sheetIx, boolean hidden) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetHidden(int sheetIx, int hidden) {
        throw new UnsupportedOperationException();
    }

    @Override
    public SheetVisibility getSheetVisibility(int i) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setSheetVisibility(int i, SheetVisibility sheetVisibility) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void addToolPack(UDFFinder toopack) {
        throw new UnsupportedOperationException();
    }

    @Override
    public void setForceFormulaRecalculation(boolean value) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean getForceFormulaRecalculation() {
        throw new UnsupportedOperationException();
    }

    @Override
    public SpreadsheetVersion getSpreadsheetVersion() {
        throw new UnsupportedOperationException();
    }

    @Override
    public int addOlePackage(byte[] bytes, String s2, String s1, String s22) throws IOException {
        throw new UnsupportedOperationException();
    }
}

