/*
 * Decompiled with CFR 0.152.
 */
package com.monitorjbl.xlsx.sst;

import java.io.File;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import shadeio.annotation.JsonInclude;
import shadeio.databind.ObjectMapper;

public class FileBackedList<T>
implements AutoCloseable {
    private static final ObjectMapper mapper = new ObjectMapper().setSerializationInclusion(JsonInclude.Include.NON_NULL);
    private final Class<T> type;
    private final List<Long> pointers = new ArrayList<Long>();
    private final RandomAccessFile raf;
    private final FileChannel channel;
    private final Map<Integer, T> cache;
    private long filesize;

    public FileBackedList(Class<T> type, File file, final int cacheSize) throws IOException {
        this.type = type;
        this.raf = new RandomAccessFile(file, "rw");
        this.channel = this.raf.getChannel();
        this.filesize = this.raf.length();
        this.cache = new LinkedHashMap<Integer, T>(cacheSize, 0.75f, true){

            @Override
            public boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > cacheSize;
            }
        };
    }

    public void add(T obj) {
        try {
            this.writeToFile(obj);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public T getAt(int index) {
        if (this.cache.containsKey(index)) {
            return this.cache.get(index);
        }
        try {
            T val = this.readFromFile(this.pointers.get(index));
            this.cache.put(index, val);
            return val;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void writeToFile(T obj) throws IOException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            ByteBuffer bytes = ByteBuffer.wrap(mapper.writeValueAsBytes(obj));
            ByteBuffer length = ByteBuffer.allocate(4).putInt(bytes.array().length);
            this.channel.position(this.filesize);
            this.pointers.add(this.channel.position());
            length.flip();
            this.channel.write(length);
            this.channel.write(bytes);
            this.filesize += (long)(4 + bytes.array().length);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private T readFromFile(long pointer) throws IOException {
        FileChannel fileChannel = this.channel;
        synchronized (fileChannel) {
            FileChannel fc = this.channel.position(pointer);
            ByteBuffer buffer = ByteBuffer.wrap(new byte[4]);
            fc.read(buffer);
            buffer.flip();
            int length = buffer.getInt();
            buffer = ByteBuffer.wrap(new byte[length]);
            fc.read(buffer);
            buffer.flip();
            return mapper.readValue(buffer.array(), this.type);
        }
    }

    @Override
    public void close() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

