/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.util.Collections;
import java.util.HashMap;
import javax.xml.stream.XMLStreamReader;
import org.apache.poi.util.DocumentHelper;
import org.apache.poi.util.Removal;
import org.apache.xmlbeans.SchemaType;
import org.apache.xmlbeans.SchemaTypeLoader;
import org.apache.xmlbeans.XmlBeans;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlObject;
import org.apache.xmlbeans.XmlOptions;
import org.apache.xmlbeans.xml.stream.XMLInputStream;
import org.apache.xmlbeans.xml.stream.XMLStreamException;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class POIXMLTypeLoader {
    private static ThreadLocal<SchemaTypeLoader> typeLoader = new ThreadLocal();
    private static final String MS_OFFICE_URN = "urn:schemas-microsoft-com:office:office";
    private static final String MS_EXCEL_URN = "urn:schemas-microsoft-com:office:excel";
    private static final String MS_WORD_URN = "urn:schemas-microsoft-com:office:word";
    private static final String MS_VML_URN = "urn:schemas-microsoft-com:vml";
    public static final XmlOptions DEFAULT_XML_OPTIONS = new XmlOptions();

    private static XmlOptions getXmlOptions(XmlOptions options) {
        return options == null ? DEFAULT_XML_OPTIONS : options;
    }

    @Deprecated
    @Removal(version="4.0")
    public static void setClassLoader(ClassLoader cl) {
    }

    private static SchemaTypeLoader getTypeLoader(SchemaType type) {
        SchemaTypeLoader tl = typeLoader.get();
        if (tl == null) {
            ClassLoader cl = type.getClass().getClassLoader();
            tl = XmlBeans.typeLoaderForClassLoader(cl);
            typeLoader.set(tl);
        }
        return tl;
    }

    public static XmlObject newInstance(SchemaType type, XmlOptions options) {
        return POIXMLTypeLoader.getTypeLoader(type).newInstance(type, POIXMLTypeLoader.getXmlOptions(options));
    }

    public static XmlObject parse(String xmlText, SchemaType type, XmlOptions options) throws XmlException {
        try {
            return POIXMLTypeLoader.parse(new StringReader(xmlText), type, options);
        }
        catch (IOException e) {
            throw new XmlException("Unable to parse xml bean", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject parse(File file, SchemaType type, XmlOptions options) throws XmlException, IOException {
        FileInputStream is = new FileInputStream(file);
        try {
            XmlObject xmlObject = POIXMLTypeLoader.parse(is, type, options);
            return xmlObject;
        }
        finally {
            ((InputStream)is).close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static XmlObject parse(URL file, SchemaType type, XmlOptions options) throws XmlException, IOException {
        InputStream is = file.openStream();
        try {
            XmlObject xmlObject = POIXMLTypeLoader.parse(is, type, options);
            return xmlObject;
        }
        finally {
            is.close();
        }
    }

    public static XmlObject parse(InputStream jiois, SchemaType type, XmlOptions options) throws XmlException, IOException {
        try {
            Document doc = DocumentHelper.readDocument(jiois);
            return POIXMLTypeLoader.getTypeLoader(type).parse(doc.getDocumentElement(), type, POIXMLTypeLoader.getXmlOptions(options));
        }
        catch (SAXException e) {
            throw new IOException("Unable to parse xml bean", e);
        }
    }

    public static XmlObject parse(XMLStreamReader xsr, SchemaType type, XmlOptions options) throws XmlException {
        return POIXMLTypeLoader.getTypeLoader(type).parse(xsr, type, POIXMLTypeLoader.getXmlOptions(options));
    }

    public static XmlObject parse(Reader jior, SchemaType type, XmlOptions options) throws XmlException, IOException {
        try {
            Document doc = DocumentHelper.readDocument(new InputSource(jior));
            return POIXMLTypeLoader.getTypeLoader(type).parse(doc.getDocumentElement(), type, POIXMLTypeLoader.getXmlOptions(options));
        }
        catch (SAXException e) {
            throw new XmlException("Unable to parse xml bean", e);
        }
    }

    public static XmlObject parse(Node node, SchemaType type, XmlOptions options) throws XmlException {
        return POIXMLTypeLoader.getTypeLoader(type).parse(node, type, POIXMLTypeLoader.getXmlOptions(options));
    }

    public static XmlObject parse(XMLInputStream xis, SchemaType type, XmlOptions options) throws XmlException, XMLStreamException {
        return POIXMLTypeLoader.getTypeLoader(type).parse(xis, type, POIXMLTypeLoader.getXmlOptions(options));
    }

    public static XMLInputStream newValidatingXMLInputStream(XMLInputStream xis, SchemaType type, XmlOptions options) throws XmlException, XMLStreamException {
        return POIXMLTypeLoader.getTypeLoader(type).newValidatingXMLInputStream(xis, type, POIXMLTypeLoader.getXmlOptions(options));
    }

    static {
        DEFAULT_XML_OPTIONS.setSaveOuter();
        DEFAULT_XML_OPTIONS.setUseDefaultNamespace();
        DEFAULT_XML_OPTIONS.setSaveAggressiveNamespaces();
        DEFAULT_XML_OPTIONS.setCharacterEncoding("UTF-8");
        HashMap<String, String> map2 = new HashMap<String, String>();
        map2.put("http://schemas.openxmlformats.org/drawingml/2006/main", "a");
        map2.put("http://schemas.openxmlformats.org/drawingml/2006/chart", "c");
        map2.put("http://schemas.openxmlformats.org/drawingml/2006/wordprocessingDrawing", "wp");
        map2.put("http://schemas.openxmlformats.org/markup-compatibility/2006", "ve");
        map2.put("http://schemas.openxmlformats.org/officeDocument/2006/math", "m");
        map2.put("http://schemas.openxmlformats.org/officeDocument/2006/relationships", "r");
        map2.put("http://schemas.openxmlformats.org/officeDocument/2006/docPropsVTypes", "vt");
        map2.put("http://schemas.openxmlformats.org/presentationml/2006/main", "p");
        map2.put("http://schemas.openxmlformats.org/wordprocessingml/2006/main", "w");
        map2.put("http://schemas.microsoft.com/office/word/2006/wordml", "wne");
        map2.put(MS_OFFICE_URN, "o");
        map2.put(MS_EXCEL_URN, "x");
        map2.put(MS_WORD_URN, "w10");
        map2.put(MS_VML_URN, "v");
        DEFAULT_XML_OPTIONS.setSaveSuggestedPrefixes(Collections.unmodifiableMap(map2));
    }
}

