/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ddf;

import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.ddf.EscherRecord;
import org.apache.poi.ddf.EscherRecordFactory;
import org.apache.poi.ddf.EscherSerializationListener;
import org.apache.poi.util.HexDump;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Removal;

public final class EscherContainerRecord
extends EscherRecord
implements Iterable<EscherRecord> {
    public static final short DGG_CONTAINER = -4096;
    public static final short BSTORE_CONTAINER = -4095;
    public static final short DG_CONTAINER = -4094;
    public static final short SPGR_CONTAINER = -4093;
    public static final short SP_CONTAINER = -4092;
    public static final short SOLVER_CONTAINER = -4091;
    private static final POILogger log = POILogFactory.getLogger(EscherContainerRecord.class);
    private int _remainingLength;
    private final List<EscherRecord> _childRecords = new ArrayList<EscherRecord>();

    @Override
    public int fillFields(byte[] data, int pOffset, EscherRecordFactory recordFactory) {
        int bytesRemaining = this.readHeader(data, pOffset);
        int bytesWritten = 8;
        int offset = pOffset + 8;
        while (bytesRemaining > 0 && offset < data.length) {
            EscherRecord child = recordFactory.createRecord(data, offset);
            int childBytesWritten = child.fillFields(data, offset, recordFactory);
            bytesWritten += childBytesWritten;
            this.addChildRecord(child);
            if ((offset += childBytesWritten) < data.length || (bytesRemaining -= childBytesWritten) <= 0) continue;
            this._remainingLength = bytesRemaining;
            if (!log.check(5)) continue;
            log.log(5, "Not enough Escher data: " + bytesRemaining + " bytes remaining but no space left");
        }
        return bytesWritten;
    }

    @Override
    public int serialize(int offset, byte[] data, EscherSerializationListener listener) {
        listener.beforeRecordSerialize(offset, this.getRecordId(), this);
        LittleEndian.putShort(data, offset, this.getOptions());
        LittleEndian.putShort(data, offset + 2, this.getRecordId());
        int remainingBytes = 0;
        for (EscherRecord r : this) {
            remainingBytes += r.getRecordSize();
        }
        LittleEndian.putInt(data, offset + 4, remainingBytes += this._remainingLength);
        int pos = offset + 8;
        for (EscherRecord r : this) {
            pos += r.serialize(pos, data, listener);
        }
        listener.afterRecordSerialize(pos, this.getRecordId(), pos - offset, this);
        return pos - offset;
    }

    @Override
    public int getRecordSize() {
        int childRecordsSize = 0;
        for (EscherRecord r : this) {
            childRecordsSize += r.getRecordSize();
        }
        return 8 + childRecordsSize;
    }

    public boolean hasChildOfType(short recordId) {
        for (EscherRecord r : this) {
            if (r.getRecordId() != recordId) continue;
            return true;
        }
        return false;
    }

    @Override
    public EscherRecord getChild(int index) {
        return this._childRecords.get(index);
    }

    @Override
    public List<EscherRecord> getChildRecords() {
        return new ArrayList<EscherRecord>(this._childRecords);
    }

    @Removal(version="3.18")
    @Deprecated
    public Iterator<EscherRecord> getChildIterator() {
        return this.iterator();
    }

    @Override
    public Iterator<EscherRecord> iterator() {
        return Collections.unmodifiableList(this._childRecords).iterator();
    }

    @Override
    public void setChildRecords(List<EscherRecord> childRecords) {
        if (childRecords == this._childRecords) {
            throw new IllegalStateException("Child records private data member has escaped");
        }
        this._childRecords.clear();
        this._childRecords.addAll(childRecords);
    }

    public boolean removeChildRecord(EscherRecord toBeRemoved) {
        return this._childRecords.remove(toBeRemoved);
    }

    public List<EscherContainerRecord> getChildContainers() {
        ArrayList<EscherContainerRecord> containers = new ArrayList<EscherContainerRecord>();
        for (EscherRecord r : this) {
            if (!(r instanceof EscherContainerRecord)) continue;
            containers.add((EscherContainerRecord)r);
        }
        return containers;
    }

    @Override
    public String getRecordName() {
        switch (this.getRecordId()) {
            case -4096: {
                return "DggContainer";
            }
            case -4095: {
                return "BStoreContainer";
            }
            case -4094: {
                return "DgContainer";
            }
            case -4093: {
                return "SpgrContainer";
            }
            case -4092: {
                return "SpContainer";
            }
            case -4091: {
                return "SolverContainer";
            }
        }
        return "Container 0x" + HexDump.toHex(this.getRecordId());
    }

    @Override
    public void display(PrintWriter w, int indent) {
        super.display(w, indent);
        for (EscherRecord escherRecord : this) {
            escherRecord.display(w, indent + 1);
        }
    }

    public void addChildRecord(EscherRecord record) {
        this._childRecords.add(record);
    }

    public void addChildBefore(EscherRecord record, int insertBeforeRecordId) {
        int idx = 0;
        for (EscherRecord rec : this) {
            if (rec.getRecordId() == (short)insertBeforeRecordId) break;
            ++idx;
        }
        this._childRecords.add(idx, record);
    }

    public <T extends EscherRecord> T getChildById(short recordId) {
        for (EscherRecord childRecord : this) {
            if (childRecord.getRecordId() != recordId) continue;
            EscherRecord result2 = childRecord;
            return (T)result2;
        }
        return null;
    }

    public void getRecordsById(short recordId, List<EscherRecord> out) {
        for (EscherRecord r : this) {
            if (r instanceof EscherContainerRecord) {
                EscherContainerRecord c = (EscherContainerRecord)r;
                c.getRecordsById(recordId, out);
                continue;
            }
            if (r.getRecordId() != recordId) continue;
            out.add(r);
        }
    }

    @Override
    protected Object[][] getAttributeMap() {
        ArrayList<Object> chList = new ArrayList<Object>(this._childRecords.size() * 2 + 2);
        chList.add("children");
        chList.add(this._childRecords.size());
        int count2 = 0;
        for (EscherRecord record : this) {
            chList.add("Child " + count2);
            chList.add(record);
            ++count2;
        }
        return new Object[][]{{"isContainer", this.isContainerRecord()}, chList.toArray()};
    }
}

