/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import org.apache.poi.util.IOUtils;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.LittleEndianByteArrayOutputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
class ClipboardData {
    private static final POILogger LOG = POILogFactory.getLogger(ClipboardData.class);
    private int _format = 0;
    private byte[] _value;

    ClipboardData() {
    }

    void read(LittleEndianByteArrayInputStream lei) {
        int offset = lei.getReadIndex();
        int size2 = lei.readInt();
        if (size2 < 4) {
            String msg = "ClipboardData at offset " + offset + " size less than 4 bytes " + "(doesn't even have format field!). Setting to format == 0 and hope for the best";
            LOG.log(5, msg);
            this._format = 0;
            this._value = new byte[0];
            return;
        }
        this._format = lei.readInt();
        this._value = new byte[size2 - 4];
        lei.readFully(this._value);
    }

    byte[] getValue() {
        return this._value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    byte[] toByteArray() {
        byte[] result2 = new byte[8 + this._value.length];
        LittleEndianByteArrayOutputStream bos = new LittleEndianByteArrayOutputStream(result2, 0);
        try {
            bos.writeInt(4 + this._value.length);
            bos.writeInt(this._format);
            bos.write(this._value);
            byte[] byArray = result2;
            return byArray;
        }
        finally {
            IOUtils.closeQuietly(bos);
        }
    }

    void setValue(byte[] value) {
        this._value = (byte[])value.clone();
    }
}

