/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.hpsf;

import java.io.IOException;
import java.io.OutputStream;
import java.io.UnsupportedEncodingException;
import org.apache.poi.hpsf.TypedPropertyValue;
import org.apache.poi.util.CodePageUtil;
import org.apache.poi.util.Internal;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianByteArrayInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

@Internal
class CodePageString {
    private static final POILogger LOG = POILogFactory.getLogger(CodePageString.class);
    private byte[] _value;

    CodePageString() {
    }

    void read(LittleEndianByteArrayInputStream lei) {
        int offset = lei.getReadIndex();
        int size2 = lei.readInt();
        this._value = new byte[size2];
        if (size2 == 0) {
            return;
        }
        lei.readFully(this._value);
        if (this._value[size2 - 1] != 0) {
            String msg = "CodePageString started at offset #" + offset + " is not NULL-terminated";
            LOG.log(5, msg);
        }
        TypedPropertyValue.skipPadding(lei);
    }

    String getJavaValue(int codepage) throws UnsupportedEncodingException {
        int cp = codepage == -1 ? 1252 : codepage;
        String result2 = CodePageUtil.getStringFromCodePage(this._value, cp);
        int terminator = result2.indexOf(0);
        if (terminator == -1) {
            String msg = "String terminator (\\0) for CodePageString property value not found.Continue without trimming and hope for the best.";
            LOG.log(5, msg);
            return result2;
        }
        if (terminator != result2.length() - 1) {
            String msg = "String terminator (\\0) for CodePageString property value occured before the end of string. Trimming and hope for the best.";
            LOG.log(5, msg);
        }
        return result2.substring(0, terminator);
    }

    int getSize() {
        return 4 + this._value.length;
    }

    void setJavaValue(String string2, int codepage) throws UnsupportedEncodingException {
        int cp = codepage == -1 ? 1252 : codepage;
        this._value = CodePageUtil.getBytesInCodePage(string2 + "\u0000", cp);
    }

    int write(OutputStream out) throws IOException {
        LittleEndian.putUInt(this._value.length, out);
        out.write(this._value);
        return 4 + this._value.length;
    }
}

