/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.eventfilesystem;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.poifs.eventfilesystem.POIFSReaderListener;
import org.apache.poi.poifs.filesystem.DocumentDescriptor;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;

class POIFSReaderRegistry {
    private Set<POIFSReaderListener> omnivorousListeners = new HashSet<POIFSReaderListener>();
    private Map<POIFSReaderListener, Set<DocumentDescriptor>> selectiveListeners = new HashMap<POIFSReaderListener, Set<DocumentDescriptor>>();
    private Map<DocumentDescriptor, Set<POIFSReaderListener>> chosenDocumentDescriptors = new HashMap<DocumentDescriptor, Set<POIFSReaderListener>>();

    POIFSReaderRegistry() {
    }

    void registerListener(POIFSReaderListener listener, POIFSDocumentPath path, String documentName) {
        if (!this.omnivorousListeners.contains(listener)) {
            DocumentDescriptor descriptor;
            Set<DocumentDescriptor> descriptors = this.selectiveListeners.get(listener);
            if (descriptors == null) {
                descriptors = new HashSet<DocumentDescriptor>();
                this.selectiveListeners.put(listener, descriptors);
            }
            if (descriptors.add(descriptor = new DocumentDescriptor(path, documentName))) {
                Set<POIFSReaderListener> listeners = this.chosenDocumentDescriptors.get(descriptor);
                if (listeners == null) {
                    listeners = new HashSet<POIFSReaderListener>();
                    this.chosenDocumentDescriptors.put(descriptor, listeners);
                }
                listeners.add(listener);
            }
        }
    }

    void registerListener(POIFSReaderListener listener) {
        if (!this.omnivorousListeners.contains(listener)) {
            this.removeSelectiveListener(listener);
            this.omnivorousListeners.add(listener);
        }
    }

    Iterator<POIFSReaderListener> getListeners(POIFSDocumentPath path, String name) {
        HashSet<POIFSReaderListener> rval = new HashSet<POIFSReaderListener>(this.omnivorousListeners);
        Set<POIFSReaderListener> selectiveListenersInner = this.chosenDocumentDescriptors.get(new DocumentDescriptor(path, name));
        if (selectiveListenersInner != null) {
            rval.addAll(selectiveListenersInner);
        }
        return rval.iterator();
    }

    private void removeSelectiveListener(POIFSReaderListener listener) {
        Set<DocumentDescriptor> selectedDescriptors = this.selectiveListeners.remove(listener);
        if (selectedDescriptors != null) {
            Iterator<DocumentDescriptor> iter2 = selectedDescriptors.iterator();
            while (iter2.hasNext()) {
                this.dropDocument(listener, iter2.next());
            }
        }
    }

    private void dropDocument(POIFSReaderListener listener, DocumentDescriptor descriptor) {
        Set<POIFSReaderListener> listeners = this.chosenDocumentDescriptors.get(descriptor);
        listeners.remove(listener);
        if (listeners.size() == 0) {
            this.chosenDocumentDescriptors.remove(descriptor);
        }
    }
}

