/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hpsf.ClassID;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.Entry;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.NPOIFSDocument;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSDocument;
import org.apache.poi.poifs.filesystem.OPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.POIFSDocumentPath;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.DocumentProperty;
import org.apache.poi.poifs.property.Property;

public class DirectoryNode
extends EntryNode
implements DirectoryEntry,
POIFSViewable,
Iterable<Entry> {
    private Map<String, Entry> _byname;
    private ArrayList<Entry> _entries;
    private OPOIFSFileSystem _ofilesystem;
    private NPOIFSFileSystem _nfilesystem;
    private POIFSDocumentPath _path;

    DirectoryNode(DirectoryProperty property, OPOIFSFileSystem filesystem, DirectoryNode parent) {
        this(property, parent, filesystem, null);
    }

    DirectoryNode(DirectoryProperty property, NPOIFSFileSystem nfilesystem, DirectoryNode parent) {
        this(property, parent, null, nfilesystem);
    }

    private DirectoryNode(DirectoryProperty property, DirectoryNode parent, OPOIFSFileSystem ofilesystem, NPOIFSFileSystem nfilesystem) {
        super(property, parent);
        this._ofilesystem = ofilesystem;
        this._nfilesystem = nfilesystem;
        this._path = parent == null ? new POIFSDocumentPath() : new POIFSDocumentPath(parent._path, new String[]{property.getName()});
        this._byname = new HashMap<String, Entry>();
        this._entries = new ArrayList();
        Iterator<Property> iter2 = property.getChildren();
        while (iter2.hasNext()) {
            Property child = iter2.next();
            EntryNode childNode = null;
            if (child.isDirectory()) {
                DirectoryProperty childDir = (DirectoryProperty)child;
                childNode = this._ofilesystem != null ? new DirectoryNode(childDir, this._ofilesystem, this) : new DirectoryNode(childDir, this._nfilesystem, this);
            } else {
                childNode = new DocumentNode((DocumentProperty)child, this);
            }
            this._entries.add(childNode);
            this._byname.put(childNode.getName(), childNode);
        }
    }

    public POIFSDocumentPath getPath() {
        return this._path;
    }

    public NPOIFSFileSystem getFileSystem() {
        return this._nfilesystem;
    }

    public OPOIFSFileSystem getOFileSystem() {
        return this._ofilesystem;
    }

    public NPOIFSFileSystem getNFileSystem() {
        return this._nfilesystem;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        return this.createDocumentInputStream(this.getEntry(documentName));
    }

    public DocumentInputStream createDocumentInputStream(Entry document2) throws IOException {
        if (!document2.isDocumentEntry()) {
            throw new IOException("Entry '" + document2.getName() + "' is not a DocumentEntry");
        }
        DocumentEntry entry = (DocumentEntry)document2;
        return new DocumentInputStream(entry);
    }

    DocumentEntry createDocument(OPOIFSDocument document2) throws IOException {
        DocumentProperty property = document2.getDocumentProperty();
        DocumentNode rval = new DocumentNode(property, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._ofilesystem.addDocument(document2);
        this._entries.add(rval);
        this._byname.put(property.getName(), rval);
        return rval;
    }

    DocumentEntry createDocument(NPOIFSDocument document2) throws IOException {
        DocumentProperty property = document2.getDocumentProperty();
        DocumentNode rval = new DocumentNode(property, this);
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._nfilesystem.addDocument(document2);
        this._entries.add(rval);
        this._byname.put(property.getName(), rval);
        return rval;
    }

    boolean changeName(String oldName, String newName) {
        boolean rval = false;
        EntryNode child = (EntryNode)this._byname.get(oldName);
        if (child != null && (rval = ((DirectoryProperty)this.getProperty()).changeName(child.getProperty(), newName))) {
            this._byname.remove(oldName);
            this._byname.put(child.getProperty().getName(), child);
        }
        return rval;
    }

    boolean deleteEntry(EntryNode entry) {
        boolean rval = ((DirectoryProperty)this.getProperty()).deleteChild(entry.getProperty());
        if (rval) {
            this._entries.remove(entry);
            this._byname.remove(entry.getName());
            if (this._ofilesystem != null) {
                this._ofilesystem.remove(entry);
            } else {
                try {
                    this._nfilesystem.remove(entry);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
        return rval;
    }

    @Override
    public Iterator<Entry> getEntries() {
        return this._entries.iterator();
    }

    @Override
    public Set<String> getEntryNames() {
        return this._byname.keySet();
    }

    @Override
    public boolean isEmpty() {
        return this._entries.isEmpty();
    }

    @Override
    public int getEntryCount() {
        return this._entries.size();
    }

    @Override
    public boolean hasEntry(String name) {
        return name != null && this._byname.containsKey(name);
    }

    @Override
    public Entry getEntry(String name) throws FileNotFoundException {
        Entry rval = null;
        if (name != null) {
            rval = this._byname.get(name);
        }
        if (rval == null) {
            throw new FileNotFoundException("no such entry: \"" + name + "\", had: " + this._byname.keySet());
        }
        return rval;
    }

    @Override
    public DocumentEntry createDocument(String name, InputStream stream) throws IOException {
        if (this._nfilesystem != null) {
            return this.createDocument(new NPOIFSDocument(name, this._nfilesystem, stream));
        }
        return this.createDocument(new OPOIFSDocument(name, stream));
    }

    @Override
    public DocumentEntry createDocument(String name, int size2, POIFSWriterListener writer) throws IOException {
        if (this._nfilesystem != null) {
            return this.createDocument(new NPOIFSDocument(name, size2, this._nfilesystem, writer));
        }
        return this.createDocument(new OPOIFSDocument(name, size2, this._path, writer));
    }

    @Override
    public DirectoryEntry createDirectory(String name) throws IOException {
        DirectoryNode rval;
        DirectoryProperty property = new DirectoryProperty(name);
        if (this._ofilesystem != null) {
            rval = new DirectoryNode(property, this._ofilesystem, this);
            this._ofilesystem.addDirectory(property);
        } else {
            rval = new DirectoryNode(property, this._nfilesystem, this);
            this._nfilesystem.addDirectory(property);
        }
        ((DirectoryProperty)this.getProperty()).addChild(property);
        this._entries.add(rval);
        this._byname.put(name, rval);
        return rval;
    }

    public DocumentEntry createOrUpdateDocument(String name, InputStream stream) throws IOException {
        if (!this.hasEntry(name)) {
            return this.createDocument(name, stream);
        }
        DocumentNode existing = (DocumentNode)this.getEntry(name);
        if (this._nfilesystem != null) {
            NPOIFSDocument nDoc = new NPOIFSDocument(existing);
            nDoc.replaceContents(stream);
            return existing;
        }
        this.deleteEntry(existing);
        return this.createDocument(name, stream);
    }

    @Override
    public ClassID getStorageClsid() {
        return this.getProperty().getStorageClsid();
    }

    @Override
    public void setStorageClsid(ClassID clsidStorage) {
        this.getProperty().setStorageClsid(clsidStorage);
    }

    @Override
    public boolean isDirectoryEntry() {
        return true;
    }

    @Override
    protected boolean isDeleteOK() {
        return this.isEmpty();
    }

    @Override
    public Object[] getViewableArray() {
        return new Object[0];
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        ArrayList<Object> components = new ArrayList<Object>();
        components.add(this.getProperty());
        Iterator<Entry> iter2 = this._entries.iterator();
        while (iter2.hasNext()) {
            components.add(iter2.next());
        }
        return components.iterator();
    }

    @Override
    public boolean preferArray() {
        return false;
    }

    @Override
    public String getShortDescription() {
        return this.getName();
    }

    @Override
    public Iterator<Entry> iterator() {
        return this.getEntries();
    }
}

