/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.filesystem;

import java.io.ByteArrayInputStream;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.apache.poi.poifs.common.POIFSBigBlockSize;
import org.apache.poi.poifs.common.POIFSConstants;
import org.apache.poi.poifs.dev.POIFSViewable;
import org.apache.poi.poifs.filesystem.BATManaged;
import org.apache.poi.poifs.filesystem.DirectoryEntry;
import org.apache.poi.poifs.filesystem.DirectoryNode;
import org.apache.poi.poifs.filesystem.DocumentEntry;
import org.apache.poi.poifs.filesystem.DocumentInputStream;
import org.apache.poi.poifs.filesystem.DocumentNode;
import org.apache.poi.poifs.filesystem.EntryNode;
import org.apache.poi.poifs.filesystem.NPOIFSFileSystem;
import org.apache.poi.poifs.filesystem.OPOIFSDocument;
import org.apache.poi.poifs.filesystem.POIFSWriterListener;
import org.apache.poi.poifs.property.DirectoryProperty;
import org.apache.poi.poifs.property.Property;
import org.apache.poi.poifs.property.PropertyTable;
import org.apache.poi.poifs.storage.BATBlock;
import org.apache.poi.poifs.storage.BlockAllocationTableReader;
import org.apache.poi.poifs.storage.BlockAllocationTableWriter;
import org.apache.poi.poifs.storage.BlockList;
import org.apache.poi.poifs.storage.BlockWritable;
import org.apache.poi.poifs.storage.HeaderBlock;
import org.apache.poi.poifs.storage.HeaderBlockWriter;
import org.apache.poi.poifs.storage.RawDataBlockList;
import org.apache.poi.poifs.storage.SmallBlockTableReader;
import org.apache.poi.poifs.storage.SmallBlockTableWriter;
import org.apache.poi.util.CloseIgnoringInputStream;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;
import org.apache.poi.util.Removal;

public class OPOIFSFileSystem
implements POIFSViewable {
    private static final POILogger _logger = POILogFactory.getLogger(OPOIFSFileSystem.class);
    private PropertyTable _property_table;
    private List<OPOIFSDocument> _documents;
    private DirectoryNode _root;
    private POIFSBigBlockSize bigBlockSize = POIFSConstants.SMALLER_BIG_BLOCK_SIZE_DETAILS;

    public static InputStream createNonClosingInputStream(InputStream is) {
        return new CloseIgnoringInputStream(is);
    }

    public OPOIFSFileSystem() {
        HeaderBlock header_block = new HeaderBlock(this.bigBlockSize);
        this._property_table = new PropertyTable(header_block);
        this._documents = new ArrayList<OPOIFSDocument>();
        this._root = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public OPOIFSFileSystem(InputStream stream) throws IOException {
        this();
        RawDataBlockList data_blocks;
        HeaderBlock header_block;
        boolean success = false;
        try {
            header_block = new HeaderBlock(stream);
            this.bigBlockSize = header_block.getBigBlockSize();
            data_blocks = new RawDataBlockList(stream, this.bigBlockSize);
            success = true;
        }
        finally {
            this.closeInputStream(stream, success);
        }
        new BlockAllocationTableReader(header_block.getBigBlockSize(), header_block.getBATCount(), header_block.getBATArray(), header_block.getXBATCount(), header_block.getXBATIndex(), data_blocks);
        PropertyTable properties = new PropertyTable(header_block, data_blocks);
        this.processProperties(SmallBlockTableReader.getSmallDocumentBlocks(this.bigBlockSize, data_blocks, properties.getRoot(), header_block.getSBATStart()), data_blocks, properties.getRoot().getChildren(), null, header_block.getPropertyStart());
        this.getRoot().setStorageClsid(properties.getRoot().getStorageClsid());
    }

    protected void closeInputStream(InputStream stream, boolean success) {
        if (stream.markSupported() && !(stream instanceof ByteArrayInputStream)) {
            String msg = "POIFS is closing the supplied input stream of type (" + stream.getClass().getName() + ") which supports mark/reset.  " + "This will be a problem for the caller if the stream will still be used.  " + "If that is the case the caller should wrap the input stream to avoid this close logic.  " + "This warning is only temporary and will not be present in future versions of POI.";
            _logger.log(5, msg);
        }
        try {
            stream.close();
        }
        catch (IOException e) {
            if (success) {
                throw new RuntimeException(e);
            }
            _logger.log(7, "can't close input stream", e);
        }
    }

    @Deprecated
    @Removal(version="4.0")
    public static boolean hasPOIFSHeader(InputStream inp) throws IOException {
        return NPOIFSFileSystem.hasPOIFSHeader(inp);
    }

    @Deprecated
    @Removal(version="4.0")
    public static boolean hasPOIFSHeader(byte[] header8Bytes) {
        return NPOIFSFileSystem.hasPOIFSHeader(header8Bytes);
    }

    public DocumentEntry createDocument(InputStream stream, String name) throws IOException {
        return this.getRoot().createDocument(name, stream);
    }

    public DocumentEntry createDocument(String name, int size2, POIFSWriterListener writer) throws IOException {
        return this.getRoot().createDocument(name, size2, writer);
    }

    public DirectoryEntry createDirectory(String name) throws IOException {
        return this.getRoot().createDirectory(name);
    }

    public void writeFilesystem(OutputStream stream) throws IOException {
        this._property_table.preWrite();
        SmallBlockTableWriter sbtw = new SmallBlockTableWriter(this.bigBlockSize, this._documents, this._property_table.getRoot());
        BlockAllocationTableWriter bat = new BlockAllocationTableWriter(this.bigBlockSize);
        ArrayList<BlockWritable> bm_objects = new ArrayList<BlockWritable>();
        bm_objects.addAll(this._documents);
        bm_objects.add(this._property_table);
        bm_objects.add(sbtw);
        bm_objects.add(sbtw.getSBAT());
        for (BATManaged bATManaged : bm_objects) {
            int block_count = bATManaged.countBlocks();
            if (block_count == 0) continue;
            bATManaged.setStartBlock(bat.allocateSpace(block_count));
        }
        int n = bat.createBlocks();
        HeaderBlockWriter header_block_writer = new HeaderBlockWriter(this.bigBlockSize);
        BATBlock[] xbat_blocks = header_block_writer.setBATBlocks(bat.countBlocks(), n);
        header_block_writer.setPropertyStart(this._property_table.getStartBlock());
        header_block_writer.setSBATStart(sbtw.getSBAT().getStartBlock());
        header_block_writer.setSBATBlockCount(sbtw.getSBATBlockCount());
        ArrayList<BlockWritable> writers = new ArrayList<BlockWritable>();
        writers.add(header_block_writer);
        writers.addAll(this._documents);
        writers.add(this._property_table);
        writers.add(sbtw);
        writers.add(sbtw.getSBAT());
        writers.add(bat);
        for (int j = 0; j < xbat_blocks.length; ++j) {
            writers.add(xbat_blocks[j]);
        }
        for (BlockWritable writer : writers) {
            writer.writeBlocks(stream);
        }
    }

    public static void main(String[] args) throws IOException {
        if (args.length != 2) {
            System.err.println("two arguments required: input filename and output filename");
            System.exit(1);
        }
        FileInputStream istream = new FileInputStream(args[0]);
        FileOutputStream ostream = new FileOutputStream(args[1]);
        new OPOIFSFileSystem(istream).writeFilesystem(ostream);
        istream.close();
        ostream.close();
    }

    public DirectoryNode getRoot() {
        if (this._root == null) {
            this._root = new DirectoryNode((DirectoryProperty)this._property_table.getRoot(), this, null);
        }
        return this._root;
    }

    public DocumentInputStream createDocumentInputStream(String documentName) throws IOException {
        return this.getRoot().createDocumentInputStream(documentName);
    }

    void addDocument(OPOIFSDocument document2) {
        this._documents.add(document2);
        this._property_table.addProperty(document2.getDocumentProperty());
    }

    void addDirectory(DirectoryProperty directory) {
        this._property_table.addProperty(directory);
    }

    void remove(EntryNode entry) {
        this._property_table.removeProperty(entry.getProperty());
        if (entry.isDocumentEntry()) {
            this._documents.remove(((DocumentNode)entry).getDocument());
        }
    }

    private void processProperties(BlockList small_blocks, BlockList big_blocks, Iterator<Property> properties, DirectoryNode dir, int headerPropertiesStartAt) throws IOException {
        while (properties.hasNext()) {
            DirectoryNode parent;
            Property property = properties.next();
            String name = property.getName();
            DirectoryNode directoryNode = parent = dir == null ? this.getRoot() : dir;
            if (property.isDirectory()) {
                DirectoryNode new_dir = (DirectoryNode)parent.createDirectory(name);
                new_dir.setStorageClsid(property.getStorageClsid());
                this.processProperties(small_blocks, big_blocks, ((DirectoryProperty)property).getChildren(), new_dir, headerPropertiesStartAt);
                continue;
            }
            int startBlock = property.getStartBlock();
            int size2 = property.getSize();
            OPOIFSDocument document2 = null;
            document2 = property.shouldUseSmallBlocks() ? new OPOIFSDocument(name, small_blocks.fetchBlocks(startBlock, headerPropertiesStartAt), size2) : new OPOIFSDocument(name, big_blocks.fetchBlocks(startBlock, headerPropertiesStartAt), size2);
            parent.createDocument(document2);
        }
    }

    @Override
    public Object[] getViewableArray() {
        if (this.preferArray()) {
            return this.getRoot().getViewableArray();
        }
        return new Object[0];
    }

    @Override
    public Iterator<Object> getViewableIterator() {
        if (!this.preferArray()) {
            return this.getRoot().getViewableIterator();
        }
        return Collections.emptyList().iterator();
    }

    @Override
    public boolean preferArray() {
        return this.getRoot().preferArray();
    }

    @Override
    public String getShortDescription() {
        return "POIFS FileSystem";
    }

    public int getBigBlockSize() {
        return this.bigBlockSize.getBigBlockSize();
    }

    public POIFSBigBlockSize getBigBlockSizeDetails() {
        return this.bigBlockSize;
    }
}

