/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.poifs.macros;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.util.Map;
import org.apache.poi.poifs.macros.VBAMacroReader;
import org.apache.poi.util.StringUtil;

public class VBAMacroExtractor {
    public static void main(String[] args) throws IOException {
        if (args.length == 0) {
            System.err.println("Use:");
            System.err.println("   VBAMacroExtractor <office.doc> [output]");
            System.err.println("");
            System.err.println("If an output directory is given, macros are written there");
            System.err.println("Otherwise they are output to the screen");
            System.exit(1);
        }
        File input2 = new File(args[0]);
        File output = null;
        if (args.length > 1) {
            output = new File(args[1]);
        }
        VBAMacroExtractor extractor = new VBAMacroExtractor();
        extractor.extract(input2, output);
    }

    public void extract(File input2, File outputDir, String extension2) throws IOException {
        if (!input2.exists()) {
            throw new FileNotFoundException(input2.toString());
        }
        System.err.print("Extracting VBA Macros from " + input2 + " to ");
        if (outputDir != null) {
            if (!outputDir.exists() && !outputDir.mkdirs()) {
                throw new IOException("Output directory " + outputDir + " could not be created");
            }
            System.err.println(outputDir);
        } else {
            System.err.println("STDOUT");
        }
        VBAMacroReader reader = new VBAMacroReader(input2);
        Map<String, String> macros2 = reader.readMacros();
        reader.close();
        String divider = "---------------------------------------";
        for (Map.Entry<String, String> entry : macros2.entrySet()) {
            String moduleName = entry.getKey();
            String moduleCode = entry.getValue();
            if (outputDir == null) {
                System.out.println("---------------------------------------");
                System.out.println(moduleName);
                System.out.println("");
                System.out.println(moduleCode);
                continue;
            }
            File out = new File(outputDir, moduleName + extension2);
            FileOutputStream fout = new FileOutputStream(out);
            OutputStreamWriter fwriter = new OutputStreamWriter((OutputStream)fout, StringUtil.UTF8);
            fwriter.write(moduleCode);
            fwriter.close();
            fout.close();
            System.out.println("Extracted " + out);
        }
        if (outputDir == null) {
            System.out.println("---------------------------------------");
        }
    }

    public void extract(File input2, File outputDir) throws IOException {
        this.extract(input2, outputDir, ".vba");
    }
}

