/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.sl.draw;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.LinearGradientPaint;
import java.awt.Paint;
import java.awt.RadialGradientPaint;
import java.awt.TexturePaint;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.sl.draw.DrawPictureShape;
import org.apache.poi.sl.draw.DrawShape;
import org.apache.poi.sl.draw.ImageRenderer;
import org.apache.poi.sl.draw.PathGradientPaint;
import org.apache.poi.sl.usermodel.ColorStyle;
import org.apache.poi.sl.usermodel.PaintStyle;
import org.apache.poi.sl.usermodel.PlaceableShape;
import org.apache.poi.util.POILogFactory;
import org.apache.poi.util.POILogger;

public class DrawPaint {
    private static final POILogger LOG = POILogFactory.getLogger(DrawPaint.class);
    private static final Color TRANSPARENT = new Color(1.0f, 1.0f, 1.0f, 0.0f);
    protected PlaceableShape<?, ?> shape;

    public DrawPaint(PlaceableShape<?, ?> shape) {
        this.shape = shape;
    }

    public static PaintStyle.SolidPaint createSolidPaint(Color color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public static PaintStyle.SolidPaint createSolidPaint(ColorStyle color) {
        return color == null ? null : new SimpleSolidPaint(color);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint) {
        return this.getPaint(graphics, paint, PaintStyle.PaintModifier.NORM);
    }

    public Paint getPaint(Graphics2D graphics, PaintStyle paint, PaintStyle.PaintModifier modifier) {
        if (modifier == PaintStyle.PaintModifier.NONE) {
            return null;
        }
        if (paint instanceof PaintStyle.SolidPaint) {
            return this.getSolidPaint((PaintStyle.SolidPaint)paint, graphics, modifier);
        }
        if (paint instanceof PaintStyle.GradientPaint) {
            return this.getGradientPaint((PaintStyle.GradientPaint)paint, graphics);
        }
        if (paint instanceof PaintStyle.TexturePaint) {
            return this.getTexturePaint((PaintStyle.TexturePaint)paint, graphics);
        }
        return null;
    }

    protected Paint getSolidPaint(PaintStyle.SolidPaint fill2, Graphics2D graphics, final PaintStyle.PaintModifier modifier) {
        final ColorStyle orig = fill2.getSolidColor();
        ColorStyle cs = new ColorStyle(){

            @Override
            public Color getColor() {
                return orig.getColor();
            }

            @Override
            public int getAlpha() {
                return orig.getAlpha();
            }

            @Override
            public int getHueOff() {
                return orig.getHueOff();
            }

            @Override
            public int getHueMod() {
                return orig.getHueMod();
            }

            @Override
            public int getSatOff() {
                return orig.getSatOff();
            }

            @Override
            public int getSatMod() {
                return orig.getSatMod();
            }

            @Override
            public int getLumOff() {
                return orig.getLumOff();
            }

            @Override
            public int getLumMod() {
                return orig.getLumMod();
            }

            @Override
            public int getShade() {
                int shade = orig.getShade();
                switch (modifier) {
                    case DARKEN: {
                        return Math.min(100000, Math.max(0, shade) + 40000);
                    }
                    case DARKEN_LESS: {
                        return Math.min(100000, Math.max(0, shade) + 20000);
                    }
                }
                return shade;
            }

            @Override
            public int getTint() {
                int tint = orig.getTint();
                switch (modifier) {
                    case LIGHTEN: {
                        return Math.min(100000, Math.max(0, tint) + 40000);
                    }
                    case LIGHTEN_LESS: {
                        return Math.min(100000, Math.max(0, tint) + 20000);
                    }
                }
                return tint;
            }
        };
        return DrawPaint.applyColorTransform(cs);
    }

    protected Paint getGradientPaint(PaintStyle.GradientPaint fill2, Graphics2D graphics) {
        switch (fill2.getGradientType()) {
            case linear: {
                return this.createLinearGradientPaint(fill2, graphics);
            }
            case circular: {
                return this.createRadialGradientPaint(fill2, graphics);
            }
            case shape: {
                return this.createPathGradientPaint(fill2, graphics);
            }
        }
        throw new UnsupportedOperationException("gradient fill of type " + fill2 + " not supported.");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected Paint getTexturePaint(PaintStyle.TexturePaint fill2, Graphics2D graphics) {
        InputStream is = fill2.getImageData();
        if (is == null) {
            return null;
        }
        assert (graphics != null);
        ImageRenderer renderer = DrawPictureShape.getImageRenderer(graphics, fill2.getContentType());
        try {
            try {
                renderer.loadImage(is, fill2.getContentType());
            }
            finally {
                is.close();
            }
        }
        catch (IOException e) {
            LOG.log(7, "Can't load image data - using transparent color", e);
            return null;
        }
        int alpha = fill2.getAlpha();
        if (0 <= alpha && alpha < 100000) {
            renderer.setAlpha((float)alpha / 100000.0f);
        }
        Rectangle2D textAnchor = this.shape.getAnchor();
        BufferedImage image = "image/x-wmf".equals(fill2.getContentType()) ? renderer.getImage(new Dimension((int)textAnchor.getWidth(), (int)textAnchor.getHeight())) : renderer.getImage();
        if (image == null) {
            LOG.log(7, "Can't load image data");
            return null;
        }
        TexturePaint paint = new TexturePaint(image, textAnchor);
        return paint;
    }

    public static Color applyColorTransform(ColorStyle color) {
        if (color == null || color.getColor() == null) {
            return TRANSPARENT;
        }
        Color result2 = color.getColor();
        double alpha = DrawPaint.getAlpha(result2, color);
        double[] hsl = DrawPaint.RGB2HSL(result2);
        DrawPaint.applyHslModOff(hsl, 0, color.getHueMod(), color.getHueOff());
        DrawPaint.applyHslModOff(hsl, 1, color.getSatMod(), color.getSatOff());
        DrawPaint.applyHslModOff(hsl, 2, color.getLumMod(), color.getLumOff());
        DrawPaint.applyShade(hsl, color);
        DrawPaint.applyTint(hsl, color);
        result2 = DrawPaint.HSL2RGB(hsl[0], hsl[1], hsl[2], alpha);
        return result2;
    }

    private static double getAlpha(Color c, ColorStyle fc) {
        double alpha = (double)c.getAlpha() / 255.0;
        int fcAlpha = fc.getAlpha();
        if (fcAlpha != -1) {
            alpha *= (double)fcAlpha / 100000.0;
        }
        return Math.min(1.0, Math.max(0.0, alpha));
    }

    private static void applyHslModOff(double[] hsl, int hslPart, int mod, int off) {
        if (mod == -1) {
            mod = 100000;
        }
        if (off == -1) {
            off = 0;
        }
        if (mod != 100000 || off != 0) {
            double fOff = (double)off / 1000.0;
            double fMod = (double)mod / 100000.0;
            hsl[hslPart] = hsl[hslPart] * fMod + fOff;
        }
    }

    private static void applyShade(double[] hsl, ColorStyle fc) {
        int shade = fc.getShade();
        if (shade == -1) {
            return;
        }
        double shadePct = (double)shade / 100000.0;
        hsl[2] = hsl[2] * (1.0 - shadePct);
    }

    private static void applyTint(double[] hsl, ColorStyle fc) {
        int tint = fc.getTint();
        if (tint == -1) {
            return;
        }
        double tintPct = (double)tint / 100000.0;
        hsl[2] = hsl[2] * (1.0 - tintPct) + (100.0 - 100.0 * (1.0 - tintPct));
    }

    protected Paint createLinearGradientPaint(PaintStyle.GradientPaint fill2, Graphics2D graphics) {
        double angle = fill2.getGradientAngle();
        if (!fill2.isRotatedWithShape()) {
            angle -= this.shape.getRotation();
        }
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        double h = anchor.getHeight();
        double w = anchor.getWidth();
        double x = anchor.getX();
        double y = anchor.getY();
        AffineTransform at = AffineTransform.getRotateInstance(Math.toRadians(angle), anchor.getCenterX(), anchor.getCenterY());
        double diagonal = Math.sqrt(h * h + w * w);
        Point2D p1 = new Point2D.Double(x + w / 2.0 - diagonal / 2.0, y + h / 2.0);
        p1 = at.transform(p1, null);
        Point2D p2 = new Point2D.Double(x + w, y + h / 2.0);
        if (p1.equals(p2 = at.transform(p2, null))) {
            return null;
        }
        float[] fractions = fill2.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill2.getGradientColors()) {
            colors[i++] = fc == null ? TRANSPARENT : DrawPaint.applyColorTransform(fc);
        }
        return new LinearGradientPaint(p1, p2, fractions, colors);
    }

    protected Paint createRadialGradientPaint(PaintStyle.GradientPaint fill2, Graphics2D graphics) {
        Rectangle2D anchor = DrawShape.getAnchor(graphics, this.shape);
        Point2D.Double pCenter = new Point2D.Double(anchor.getX() + anchor.getWidth() / 2.0, anchor.getY() + anchor.getHeight() / 2.0);
        float radius = (float)Math.max(anchor.getWidth(), anchor.getHeight());
        float[] fractions = fill2.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill2.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        return new RadialGradientPaint(pCenter, radius, fractions, colors);
    }

    protected Paint createPathGradientPaint(PaintStyle.GradientPaint fill2, Graphics2D graphics) {
        float[] fractions = fill2.getGradientFractions();
        Color[] colors = new Color[fractions.length];
        int i = 0;
        for (ColorStyle fc : fill2.getGradientColors()) {
            colors[i++] = DrawPaint.applyColorTransform(fc);
        }
        return new PathGradientPaint(colors, fractions);
    }

    protected void snapToAnchor(Point2D p, Rectangle2D anchor) {
        if (p.getX() < anchor.getX()) {
            p.setLocation(anchor.getX(), p.getY());
        } else if (p.getX() > anchor.getX() + anchor.getWidth()) {
            p.setLocation(anchor.getX() + anchor.getWidth(), p.getY());
        }
        if (p.getY() < anchor.getY()) {
            p.setLocation(p.getX(), anchor.getY());
        } else if (p.getY() > anchor.getY() + anchor.getHeight()) {
            p.setLocation(p.getX(), anchor.getY() + anchor.getHeight());
        }
    }

    public static Color HSL2RGB(double h, double s2, double l, double alpha) {
        s2 = Math.max(0.0, Math.min(100.0, s2));
        l = Math.max(0.0, Math.min(100.0, l));
        if (alpha < 0.0 || alpha > 1.0) {
            String message = "Color parameter outside of expected range - Alpha: " + alpha;
            throw new IllegalArgumentException(message);
        }
        h %= 360.0;
        double q = (l /= 100.0) < 0.5 ? l * (1.0 + s2) : l + (s2 /= 100.0) - s2 * l;
        double p = 2.0 * l - q;
        double r = Math.max(0.0, DrawPaint.HUE2RGB(p, q, (h /= 360.0) + 0.3333333333333333));
        double g = Math.max(0.0, DrawPaint.HUE2RGB(p, q, h));
        double b = Math.max(0.0, DrawPaint.HUE2RGB(p, q, h - 0.3333333333333333));
        r = Math.min(r, 1.0);
        g = Math.min(g, 1.0);
        b = Math.min(b, 1.0);
        return new Color((float)r, (float)g, (float)b, (float)alpha);
    }

    private static double HUE2RGB(double p, double q, double h) {
        if (h < 0.0) {
            h += 1.0;
        }
        if (h > 1.0) {
            h -= 1.0;
        }
        if (6.0 * h < 1.0) {
            return p + (q - p) * 6.0 * h;
        }
        if (2.0 * h < 1.0) {
            return q;
        }
        if (3.0 * h < 2.0) {
            return p + (q - p) * 6.0 * (0.6666666666666666 - h);
        }
        return p;
    }

    private static double[] RGB2HSL(Color color) {
        float[] rgb = color.getRGBColorComponents(null);
        double r = rgb[0];
        double g = rgb[1];
        double b = rgb[2];
        double min2 = Math.min(r, Math.min(g, b));
        double max2 = Math.max(r, Math.max(g, b));
        double h = 0.0;
        if (max2 == min2) {
            h = 0.0;
        } else if (max2 == r) {
            h = (60.0 * (g - b) / (max2 - min2) + 360.0) % 360.0;
        } else if (max2 == g) {
            h = 60.0 * (b - r) / (max2 - min2) + 120.0;
        } else if (max2 == b) {
            h = 60.0 * (r - g) / (max2 - min2) + 240.0;
        }
        double l = (max2 + min2) / 2.0;
        double s2 = 0.0;
        s2 = max2 == min2 ? 0.0 : (l <= 0.5 ? (max2 - min2) / (max2 + min2) : (max2 - min2) / (2.0 - max2 - min2));
        return new double[]{h, s2 * 100.0, l * 100.0};
    }

    public static int srgb2lin(float sRGB) {
        if ((double)sRGB <= 0.04045) {
            return (int)Math.rint(100000.0 * (double)sRGB / 12.92);
        }
        return (int)Math.rint(100000.0 * Math.pow(((double)sRGB + 0.055) / 1.055, 2.4));
    }

    public static float lin2srgb(int linRGB) {
        if ((double)linRGB <= 0.0031308) {
            return (float)((double)linRGB / 100000.0 * 12.92);
        }
        return (float)(1.055 * Math.pow((double)linRGB / 100000.0, 0.4166666666666667) - 0.055);
    }

    private static class SimpleSolidPaint
    implements PaintStyle.SolidPaint {
        private final ColorStyle solidColor;

        SimpleSolidPaint(final Color color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = new ColorStyle(){

                @Override
                public Color getColor() {
                    return new Color(color.getRed(), color.getGreen(), color.getBlue());
                }

                @Override
                public int getAlpha() {
                    return (int)Math.round((double)color.getAlpha() * 100000.0 / 255.0);
                }

                @Override
                public int getHueOff() {
                    return -1;
                }

                @Override
                public int getHueMod() {
                    return -1;
                }

                @Override
                public int getSatOff() {
                    return -1;
                }

                @Override
                public int getSatMod() {
                    return -1;
                }

                @Override
                public int getLumOff() {
                    return -1;
                }

                @Override
                public int getLumMod() {
                    return -1;
                }

                @Override
                public int getShade() {
                    return -1;
                }

                @Override
                public int getTint() {
                    return -1;
                }
            };
        }

        SimpleSolidPaint(ColorStyle color) {
            if (color == null) {
                throw new NullPointerException("Color needs to be specified");
            }
            this.solidColor = color;
        }

        @Override
        public ColorStyle getSolidColor() {
            return this.solidColor;
        }
    }
}

