/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.ss.formula.functions;

import org.apache.poi.ss.formula.eval.ErrorEval;
import org.apache.poi.ss.formula.eval.EvaluationException;
import org.apache.poi.ss.formula.eval.OperandResolver;
import org.apache.poi.ss.formula.eval.StringEval;
import org.apache.poi.ss.formula.eval.ValueEval;
import org.apache.poi.ss.formula.functions.Fixed2ArgFunction;

public class Roman
extends Fixed2ArgFunction {
    public static final int[] VALUES = new int[]{1000, 900, 500, 400, 100, 90, 50, 40, 10, 9, 5, 4, 1};
    public static final String[] ROMAN = new String[]{"M", "CM", "D", "CD", "C", "XC", "L", "XL", "X", "IX", "V", "IV", "I"};

    @Override
    public ValueEval evaluate(int srcRowIndex, int srcColumnIndex, ValueEval numberVE, ValueEval formVE) {
        int number = 0;
        try {
            ValueEval ve = OperandResolver.getSingleValue(numberVE, srcRowIndex, srcColumnIndex);
            number = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number > 3999) {
            return ErrorEval.VALUE_INVALID;
        }
        if (number == 0) {
            return new StringEval("");
        }
        int form = 0;
        try {
            ValueEval ve = OperandResolver.getSingleValue(formVE, srcRowIndex, srcColumnIndex);
            form = OperandResolver.coerceValueToInt(ve);
        }
        catch (EvaluationException e) {
            return ErrorEval.NUM_ERROR;
        }
        if (form > 4 || form < 0) {
            return ErrorEval.VALUE_INVALID;
        }
        String result2 = this.integerToRoman(number);
        if (form == 0) {
            return new StringEval(result2);
        }
        return new StringEval(this.makeConcise(result2, form));
    }

    private String integerToRoman(int number) {
        StringBuilder result2 = new StringBuilder();
        for (int i = 0; i < 13; ++i) {
            while (number >= VALUES[i]) {
                number -= VALUES[i];
                result2.append(ROMAN[i]);
            }
        }
        return result2.toString();
    }

    public String makeConcise(String result2, int form) {
        if (form > 0) {
            result2 = result2.replaceAll("XLV", "VL");
            result2 = result2.replaceAll("XCV", "VC");
            result2 = result2.replaceAll("CDL", "LD");
            result2 = result2.replaceAll("CML", "LM");
            result2 = result2.replaceAll("CMVC", "LMVL");
        }
        if (form == 1) {
            result2 = result2.replaceAll("CDXC", "LDXL");
            result2 = result2.replaceAll("CDVC", "LDVL");
            result2 = result2.replaceAll("CMXC", "LMXL");
            result2 = result2.replaceAll("XCIX", "VCIV");
            result2 = result2.replaceAll("XLIX", "VLIV");
        }
        if (form > 1) {
            result2 = result2.replaceAll("XLIX", "IL");
            result2 = result2.replaceAll("XCIX", "IC");
            result2 = result2.replaceAll("CDXC", "XD");
            result2 = result2.replaceAll("CDVC", "XDV");
            result2 = result2.replaceAll("CDIC", "XDIX");
            result2 = result2.replaceAll("LMVL", "XMV");
            result2 = result2.replaceAll("CMIC", "XMIX");
            result2 = result2.replaceAll("CMXC", "XM");
        }
        if (form > 2) {
            result2 = result2.replaceAll("XDV", "VD");
            result2 = result2.replaceAll("XDIX", "VDIV");
            result2 = result2.replaceAll("XMV", "VM");
            result2 = result2.replaceAll("XMIX", "VMIV");
        }
        if (form == 4) {
            result2 = result2.replaceAll("VDIV", "ID");
            result2 = result2.replaceAll("VMIV", "IM");
        }
        return result2;
    }
}

