/*
 * Decompiled with CFR 0.152.
 */
package org.apache.poi.util;

import java.io.FilterInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.poi.util.LittleEndian;
import org.apache.poi.util.LittleEndianInput;
import org.apache.poi.util.SuppressForbidden;

public class LittleEndianInputStream
extends FilterInputStream
implements LittleEndianInput {
    private static final int EOF = -1;

    public LittleEndianInputStream(InputStream is) {
        super(is);
    }

    @Override
    @SuppressForbidden(value="just delegating")
    public int available() {
        try {
            return super.available();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte readByte() {
        return (byte)this.readUByte();
    }

    @Override
    public int readUByte() {
        byte[] buf = new byte[1];
        try {
            LittleEndianInputStream.checkEOF(this.read(buf), 1);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return LittleEndian.getUByte(buf);
    }

    @Override
    public double readDouble() {
        return Double.longBitsToDouble(this.readLong());
    }

    @Override
    public int readInt() {
        byte[] buf = new byte[4];
        try {
            LittleEndianInputStream.checkEOF(this.read(buf), buf.length);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return LittleEndian.getInt(buf);
    }

    public long readUInt() {
        long retNum = this.readInt();
        return retNum & 0xFFFFFFFFL;
    }

    @Override
    public long readLong() {
        byte[] buf = new byte[8];
        try {
            LittleEndianInputStream.checkEOF(this.read(buf), 8);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return LittleEndian.getLong(buf);
    }

    @Override
    public short readShort() {
        return (short)this.readUShort();
    }

    @Override
    public int readUShort() {
        byte[] buf = new byte[2];
        try {
            LittleEndianInputStream.checkEOF(this.read(buf), 2);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
        return LittleEndian.getUShort(buf);
    }

    private static void checkEOF(int actualBytes, int expectedBytes) {
        if (expectedBytes != 0 && (actualBytes == -1 || actualBytes != expectedBytes)) {
            throw new RuntimeException("Unexpected end-of-file");
        }
    }

    @Override
    public void readFully(byte[] buf) {
        this.readFully(buf, 0, buf.length);
    }

    @Override
    public void readFully(byte[] buf, int off, int len) {
        try {
            LittleEndianInputStream.checkEOF(this._read(buf, off, len), len);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    private int _read(byte[] buffer, int offset, int length) throws IOException {
        int location;
        int remaining;
        int count2;
        for (remaining = length; remaining > 0 && -1 != (count2 = this.read(buffer, offset + (location = length - remaining), remaining)); remaining -= count2) {
        }
        return length - remaining;
    }

    @Override
    public void readPlain(byte[] buf, int off, int len) {
        this.readFully(buf, off, len);
    }
}

