/*
 * Decompiled with CFR 0.152.
 */
package shadeio.annotation;

import java.io.Serializable;
import java.lang.annotation.ElementType;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.annotation.Target;
import shadeio.annotation.JacksonAnnotation;
import shadeio.annotation.JacksonAnnotationValue;

@Target(value={ElementType.ANNOTATION_TYPE, ElementType.METHOD, ElementType.FIELD, ElementType.TYPE, ElementType.PARAMETER})
@Retention(value=RetentionPolicy.RUNTIME)
@JacksonAnnotation
public @interface JsonInclude {
    public Include value() default Include.ALWAYS;

    public Include content() default Include.ALWAYS;

    public static class Value
    implements JacksonAnnotationValue<JsonInclude>,
    Serializable {
        private static final long serialVersionUID = 1L;
        protected static final Value EMPTY = new Value(Include.USE_DEFAULTS, Include.USE_DEFAULTS);
        protected final Include _valueInclusion;
        protected final Include _contentInclusion;

        public Value(JsonInclude src) {
            this(src.value(), src.content());
        }

        protected Value(Include vi, Include ci) {
            this._valueInclusion = vi == null ? Include.USE_DEFAULTS : vi;
            this._contentInclusion = ci == null ? Include.USE_DEFAULTS : ci;
        }

        public static Value empty() {
            return EMPTY;
        }

        public static Value merge(Value base, Value overrides) {
            return base == null ? overrides : base.withOverrides(overrides);
        }

        public static Value mergeAll(Value ... values) {
            Value result2 = null;
            for (Value curr : values) {
                if (curr == null) continue;
                result2 = result2 == null ? curr : result2.withOverrides(curr);
            }
            return result2;
        }

        protected Object readResolve() {
            if (this._valueInclusion == Include.USE_DEFAULTS && this._contentInclusion == Include.USE_DEFAULTS) {
                return EMPTY;
            }
            return this;
        }

        public Value withOverrides(Value overrides) {
            boolean ciDiff;
            if (overrides == null || overrides == EMPTY) {
                return this;
            }
            Include vi = overrides._valueInclusion;
            Include ci = overrides._contentInclusion;
            boolean viDiff = vi != this._valueInclusion && vi != Include.USE_DEFAULTS;
            boolean bl = ciDiff = ci != this._contentInclusion && ci != Include.USE_DEFAULTS;
            if (viDiff) {
                if (ciDiff) {
                    return new Value(vi, ci);
                }
                return new Value(vi, this._contentInclusion);
            }
            if (ciDiff) {
                return new Value(this._valueInclusion, ci);
            }
            return this;
        }

        public static Value construct(Include valueIncl, Include contentIncl) {
            if (!(valueIncl != Include.USE_DEFAULTS && valueIncl != null || contentIncl != Include.USE_DEFAULTS && contentIncl != null)) {
                return EMPTY;
            }
            return new Value(valueIncl, contentIncl);
        }

        public static Value from(JsonInclude src) {
            if (src == null) {
                return null;
            }
            Include vi = src.value();
            Include ci = src.content();
            if (vi == Include.USE_DEFAULTS && ci == Include.USE_DEFAULTS) {
                return EMPTY;
            }
            return new Value(vi, ci);
        }

        public Value withValueInclusion(Include incl) {
            return incl == this._valueInclusion ? this : new Value(incl, this._contentInclusion);
        }

        public Value withContentInclusion(Include incl) {
            return incl == this._contentInclusion ? this : new Value(this._valueInclusion, incl);
        }

        @Override
        public Class<JsonInclude> valueFor() {
            return JsonInclude.class;
        }

        public Include getValueInclusion() {
            return this._valueInclusion;
        }

        public Include getContentInclusion() {
            return this._contentInclusion;
        }

        public String toString() {
            return String.format("[value=%s,content=%s]", new Object[]{this._valueInclusion, this._contentInclusion});
        }

        public int hashCode() {
            return (this._valueInclusion.hashCode() << 2) + this._contentInclusion.hashCode();
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (o == null) {
                return false;
            }
            if (o.getClass() != this.getClass()) {
                return false;
            }
            Value other = (Value)o;
            return other._valueInclusion == this._valueInclusion && other._contentInclusion == this._contentInclusion;
        }
    }

    public static enum Include {
        ALWAYS,
        NON_NULL,
        NON_ABSENT,
        NON_EMPTY,
        NON_DEFAULT,
        USE_DEFAULTS;

    }
}

