/*
 * Decompiled with CFR 0.152.
 */
package shadeio.databind.deser.impl;

import java.io.IOException;
import java.lang.annotation.Annotation;
import java.lang.reflect.Field;
import shadeio.core.JsonParser;
import shadeio.databind.DeserializationConfig;
import shadeio.databind.DeserializationContext;
import shadeio.databind.JavaType;
import shadeio.databind.JsonDeserializer;
import shadeio.databind.MapperFeature;
import shadeio.databind.PropertyName;
import shadeio.databind.deser.SettableBeanProperty;
import shadeio.databind.introspect.AnnotatedField;
import shadeio.databind.introspect.AnnotatedMember;
import shadeio.databind.introspect.BeanPropertyDefinition;
import shadeio.databind.jsontype.TypeDeserializer;
import shadeio.databind.util.Annotations;
import shadeio.databind.util.ClassUtil;

public final class FieldProperty
extends SettableBeanProperty {
    private static final long serialVersionUID = 1L;
    protected final AnnotatedField _annotated;
    protected final transient Field _field;

    public FieldProperty(BeanPropertyDefinition propDef, JavaType type, TypeDeserializer typeDeser, Annotations contextAnnotations, AnnotatedField field2) {
        super(propDef, type, typeDeser, contextAnnotations);
        this._annotated = field2;
        this._field = field2.getAnnotated();
    }

    protected FieldProperty(FieldProperty src, JsonDeserializer<?> deser) {
        super((SettableBeanProperty)src, deser);
        this._annotated = src._annotated;
        this._field = src._field;
    }

    protected FieldProperty(FieldProperty src, PropertyName newName) {
        super((SettableBeanProperty)src, newName);
        this._annotated = src._annotated;
        this._field = src._field;
    }

    protected FieldProperty(FieldProperty src) {
        super(src);
        this._annotated = src._annotated;
        Field f = this._annotated.getAnnotated();
        if (f == null) {
            throw new IllegalArgumentException("Missing field (broken JDK (de)serialization?)");
        }
        this._field = f;
    }

    @Override
    public FieldProperty withName(PropertyName newName) {
        return new FieldProperty(this, newName);
    }

    @Override
    public FieldProperty withValueDeserializer(JsonDeserializer<?> deser) {
        if (this._valueDeserializer == deser) {
            return this;
        }
        return new FieldProperty(this, deser);
    }

    @Override
    public void fixAccess(DeserializationConfig config) {
        ClassUtil.checkAndFixAccess(this._field, config.isEnabled(MapperFeature.OVERRIDE_PUBLIC_ACCESS_MODIFIERS));
    }

    @Override
    public <A extends Annotation> A getAnnotation(Class<A> acls) {
        return this._annotated == null ? null : (A)this._annotated.getAnnotation(acls);
    }

    @Override
    public AnnotatedMember getMember() {
        return this._annotated;
    }

    @Override
    public void deserializeAndSet(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value = this.deserialize(p, ctxt);
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(p, e, value);
        }
    }

    @Override
    public Object deserializeSetAndReturn(JsonParser p, DeserializationContext ctxt, Object instance) throws IOException {
        Object value = this.deserialize(p, ctxt);
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(p, e, value);
        }
        return instance;
    }

    @Override
    public final void set(Object instance, Object value) throws IOException {
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
    }

    @Override
    public Object setAndReturn(Object instance, Object value) throws IOException {
        try {
            this._field.set(instance, value);
        }
        catch (Exception e) {
            this._throwAsIOE(e, value);
        }
        return instance;
    }

    Object readResolve() {
        return new FieldProperty(this);
    }
}

