/*
 * Decompiled with CFR 0.152.
 */
package shadeio.databind.ser.std;

import java.io.IOException;
import java.lang.reflect.Type;
import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Locale;
import java.util.TimeZone;
import shadeio.annotation.JsonFormat;
import shadeio.core.JsonGenerator;
import shadeio.core.JsonParser;
import shadeio.databind.BeanProperty;
import shadeio.databind.JavaType;
import shadeio.databind.JsonMappingException;
import shadeio.databind.JsonNode;
import shadeio.databind.JsonSerializer;
import shadeio.databind.SerializationFeature;
import shadeio.databind.SerializerProvider;
import shadeio.databind.jsonFormatVisitors.JsonFormatVisitorWrapper;
import shadeio.databind.jsonFormatVisitors.JsonValueFormat;
import shadeio.databind.ser.ContextualSerializer;
import shadeio.databind.ser.std.StdScalarSerializer;

public abstract class DateTimeSerializerBase<T>
extends StdScalarSerializer<T>
implements ContextualSerializer {
    protected final Boolean _useTimestamp;
    protected final DateFormat _customFormat;

    protected DateTimeSerializerBase(Class<T> type, Boolean useTimestamp, DateFormat customFormat) {
        super(type);
        this._useTimestamp = useTimestamp;
        this._customFormat = customFormat;
    }

    public abstract DateTimeSerializerBase<T> withFormat(Boolean var1, DateFormat var2);

    @Override
    public JsonSerializer<?> createContextual(SerializerProvider serializers, BeanProperty property) throws JsonMappingException {
        JsonFormat.Value format2;
        if (property != null && (format2 = this.findFormatOverrides(serializers, property, this.handledType())) != null) {
            JsonFormat.Shape shape = format2.getShape();
            if (shape.isNumeric()) {
                return this.withFormat(Boolean.TRUE, null);
            }
            if (shape == JsonFormat.Shape.STRING || format2.hasPattern() || format2.hasLocale() || format2.hasTimeZone()) {
                TimeZone tz = format2.getTimeZone();
                String pattern = format2.hasPattern() ? format2.getPattern() : "yyyy-MM-dd'T'HH:mm:ss.SSSZ";
                Locale loc = format2.hasLocale() ? format2.getLocale() : serializers.getLocale();
                SimpleDateFormat df = new SimpleDateFormat(pattern, loc);
                if (tz == null) {
                    tz = serializers.getTimeZone();
                }
                df.setTimeZone(tz);
                return this.withFormat(Boolean.FALSE, df);
            }
        }
        return this;
    }

    @Override
    @Deprecated
    public boolean isEmpty(T value) {
        return value == null || this._timestamp(value) == 0L;
    }

    @Override
    public boolean isEmpty(SerializerProvider serializers, T value) {
        return value == null || this._timestamp(value) == 0L;
    }

    protected abstract long _timestamp(T var1);

    @Override
    public JsonNode getSchema(SerializerProvider serializers, Type typeHint) {
        return this.createSchemaNode(this._asTimestamp(serializers) ? "number" : "string", true);
    }

    @Override
    public void acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint) throws JsonMappingException {
        this._acceptJsonFormatVisitor(visitor, typeHint, this._asTimestamp(visitor.getProvider()));
    }

    @Override
    public abstract void serialize(T var1, JsonGenerator var2, SerializerProvider var3) throws IOException;

    protected boolean _asTimestamp(SerializerProvider serializers) {
        if (this._useTimestamp != null) {
            return this._useTimestamp;
        }
        if (this._customFormat == null) {
            if (serializers != null) {
                return serializers.isEnabled(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS);
            }
            throw new IllegalArgumentException("Null SerializerProvider passed for " + this.handledType().getName());
        }
        return false;
    }

    protected void _acceptJsonFormatVisitor(JsonFormatVisitorWrapper visitor, JavaType typeHint, boolean asNumber) throws JsonMappingException {
        if (asNumber) {
            this.visitIntFormat(visitor, typeHint, JsonParser.NumberType.LONG, JsonValueFormat.UTC_MILLISEC);
        } else {
            this.visitStringFormat(visitor, typeHint, JsonValueFormat.DATE_TIME);
        }
    }
}

