/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hpsf;

import java.util.ArrayList;
import shadeio.poi.hpsf.TypedPropertyValue;
import shadeio.poi.util.Internal;
import shadeio.poi.util.LittleEndianByteArrayInputStream;

@Internal
public class Vector {
    private final short _type;
    private TypedPropertyValue[] _values;

    public Vector(short type) {
        this._type = type;
    }

    public void read(LittleEndianByteArrayInputStream lei) {
        long longLength = lei.readUInt();
        if (longLength > Integer.MAX_VALUE) {
            throw new UnsupportedOperationException("Vector is too long -- " + longLength);
        }
        int length = (int)longLength;
        ArrayList<TypedPropertyValue> values = new ArrayList<TypedPropertyValue>();
        short paddedType = this._type == 12 ? (short)0 : this._type;
        for (int i = 0; i < length; ++i) {
            TypedPropertyValue value = new TypedPropertyValue(paddedType, null);
            if (paddedType == 0) {
                value.read(lei);
            } else {
                value.readValue(lei);
            }
            values.add(value);
        }
        this._values = values.toArray(new TypedPropertyValue[values.size()]);
    }

    public TypedPropertyValue[] getValues() {
        return this._values;
    }
}

