/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.List;
import shadeio.poi.hssf.eventusermodel.HSSFListener;
import shadeio.poi.hssf.model.InternalWorkbook;
import shadeio.poi.hssf.record.BoundSheetRecord;
import shadeio.poi.hssf.record.EOFRecord;
import shadeio.poi.hssf.record.ExternSheetRecord;
import shadeio.poi.hssf.record.Record;
import shadeio.poi.hssf.record.SSTRecord;
import shadeio.poi.hssf.record.StandardRecord;
import shadeio.poi.hssf.record.SupBookRecord;
import shadeio.poi.hssf.usermodel.HSSFWorkbook;

public class EventWorkbookBuilder {
    public static InternalWorkbook createStubWorkbook(ExternSheetRecord[] externs, BoundSheetRecord[] bounds, SSTRecord sst) {
        ArrayList<Record> wbRecords = new ArrayList<Record>();
        if (bounds != null) {
            for (BoundSheetRecord boundSheetRecord : bounds) {
                wbRecords.add(boundSheetRecord);
            }
        }
        if (sst != null) {
            wbRecords.add(sst);
        }
        if (externs != null) {
            wbRecords.add(SupBookRecord.createInternalReferences((short)externs.length));
            for (StandardRecord standardRecord : externs) {
                wbRecords.add(standardRecord);
            }
        }
        wbRecords.add(EOFRecord.instance);
        return InternalWorkbook.createWorkbook(wbRecords);
    }

    public static InternalWorkbook createStubWorkbook(ExternSheetRecord[] externs, BoundSheetRecord[] bounds) {
        return EventWorkbookBuilder.createStubWorkbook(externs, bounds, null);
    }

    public static class SheetRecordCollectingListener
    implements HSSFListener {
        private final HSSFListener childListener;
        private final List<BoundSheetRecord> boundSheetRecords = new ArrayList<BoundSheetRecord>();
        private final List<ExternSheetRecord> externSheetRecords = new ArrayList<ExternSheetRecord>();
        private SSTRecord sstRecord;

        public SheetRecordCollectingListener(HSSFListener childListener) {
            this.childListener = childListener;
        }

        public BoundSheetRecord[] getBoundSheetRecords() {
            return this.boundSheetRecords.toArray(new BoundSheetRecord[this.boundSheetRecords.size()]);
        }

        public ExternSheetRecord[] getExternSheetRecords() {
            return this.externSheetRecords.toArray(new ExternSheetRecord[this.externSheetRecords.size()]);
        }

        public SSTRecord getSSTRecord() {
            return this.sstRecord;
        }

        public HSSFWorkbook getStubHSSFWorkbook() {
            HSSFWorkbook wb = HSSFWorkbook.create(this.getStubWorkbook());
            for (BoundSheetRecord bsr : this.boundSheetRecords) {
                wb.createSheet(bsr.getSheetname());
            }
            return wb;
        }

        public InternalWorkbook getStubWorkbook() {
            return EventWorkbookBuilder.createStubWorkbook(this.getExternSheetRecords(), this.getBoundSheetRecords(), this.getSSTRecord());
        }

        @Override
        public void processRecord(Record record) {
            this.processRecordInternally(record);
            this.childListener.processRecord(record);
        }

        public void processRecordInternally(Record record) {
            if (record instanceof BoundSheetRecord) {
                this.boundSheetRecords.add((BoundSheetRecord)record);
            } else if (record instanceof ExternSheetRecord) {
                this.externSheetRecords.add((ExternSheetRecord)record);
            } else if (record instanceof SSTRecord) {
                this.sstRecord = (SSTRecord)record;
            }
        }
    }
}

