/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.eventusermodel;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import shadeio.poi.hssf.eventusermodel.AbortableHSSFListener;
import shadeio.poi.hssf.eventusermodel.HSSFListener;
import shadeio.poi.hssf.eventusermodel.HSSFUserException;
import shadeio.poi.hssf.record.Record;
import shadeio.poi.hssf.record.RecordFactory;

public class HSSFRequest {
    private final Map<Short, List<HSSFListener>> _records = new HashMap<Short, List<HSSFListener>>(50);

    public void addListener(HSSFListener lsnr, short sid) {
        List<HSSFListener> list = this._records.get(sid);
        if (list == null) {
            list = new ArrayList<HSSFListener>(1);
            this._records.put(sid, list);
        }
        list.add(lsnr);
    }

    public void addListenerForAllRecords(HSSFListener lsnr) {
        short[] rectypes;
        for (short rectype : rectypes = RecordFactory.getAllKnownRecordSIDs()) {
            this.addListener(lsnr, rectype);
        }
    }

    protected short processRecord(Record rec) throws HSSFUserException {
        List<HSSFListener> listeners = this._records.get(rec.getSid());
        short userCode = 0;
        if (listeners != null) {
            for (int k = 0; k < listeners.size(); ++k) {
                HSSFListener listener;
                HSSFListener listenObj = listeners.get(k);
                if (listenObj instanceof AbortableHSSFListener) {
                    listener = (AbortableHSSFListener)listenObj;
                    userCode = ((AbortableHSSFListener)listener).abortableProcessRecord(rec);
                    if (userCode == 0) continue;
                    break;
                }
                listener = listenObj;
                listener.processRecord(rec);
            }
        }
        return userCode;
    }
}

