/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.usermodel;

import shadeio.poi.common.usermodel.HyperlinkType;
import shadeio.poi.hssf.record.common.ExtendedColor;
import shadeio.poi.hssf.usermodel.HSSFClientAnchor;
import shadeio.poi.hssf.usermodel.HSSFDataFormat;
import shadeio.poi.hssf.usermodel.HSSFExtendedColor;
import shadeio.poi.hssf.usermodel.HSSFFormulaEvaluator;
import shadeio.poi.hssf.usermodel.HSSFHyperlink;
import shadeio.poi.hssf.usermodel.HSSFRichTextString;
import shadeio.poi.hssf.usermodel.HSSFWorkbook;
import shadeio.poi.ss.usermodel.CreationHelper;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.CellReference;
import shadeio.poi.util.Internal;

public class HSSFCreationHelper
implements CreationHelper {
    private final HSSFWorkbook workbook;

    @Internal(since="3.15 beta 3")
    HSSFCreationHelper(HSSFWorkbook wb) {
        this.workbook = wb;
    }

    @Override
    public HSSFRichTextString createRichTextString(String text) {
        return new HSSFRichTextString(text);
    }

    @Override
    public HSSFDataFormat createDataFormat() {
        return this.workbook.createDataFormat();
    }

    @Override
    public HSSFHyperlink createHyperlink(HyperlinkType type) {
        return new HSSFHyperlink(type);
    }

    @Override
    public HSSFExtendedColor createExtendedColor() {
        return new HSSFExtendedColor(new ExtendedColor());
    }

    @Override
    public HSSFFormulaEvaluator createFormulaEvaluator() {
        return new HSSFFormulaEvaluator(this.workbook);
    }

    @Override
    public HSSFClientAnchor createClientAnchor() {
        return new HSSFClientAnchor();
    }

    @Override
    public AreaReference createAreaReference(String reference) {
        return new AreaReference(reference, this.workbook.getSpreadsheetVersion());
    }

    @Override
    public AreaReference createAreaReference(CellReference topLeft, CellReference bottomRight) {
        return new AreaReference(topLeft, bottomRight, this.workbook.getSpreadsheetVersion());
    }
}

