/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.usermodel;

import java.util.List;
import java.util.Map;
import shadeio.poi.ddf.EscherClientDataRecord;
import shadeio.poi.ddf.EscherContainerRecord;
import shadeio.poi.ddf.EscherOptRecord;
import shadeio.poi.ddf.EscherRecord;
import shadeio.poi.hssf.record.CommonObjectDataSubRecord;
import shadeio.poi.hssf.record.EmbeddedObjectRefSubRecord;
import shadeio.poi.hssf.record.EscherAggregate;
import shadeio.poi.hssf.record.ObjRecord;
import shadeio.poi.hssf.record.Record;
import shadeio.poi.hssf.record.SubRecord;
import shadeio.poi.hssf.record.TextObjectRecord;
import shadeio.poi.hssf.usermodel.HSSFCombobox;
import shadeio.poi.hssf.usermodel.HSSFComment;
import shadeio.poi.hssf.usermodel.HSSFObjectData;
import shadeio.poi.hssf.usermodel.HSSFPicture;
import shadeio.poi.hssf.usermodel.HSSFPolygon;
import shadeio.poi.hssf.usermodel.HSSFShapeContainer;
import shadeio.poi.hssf.usermodel.HSSFShapeGroup;
import shadeio.poi.hssf.usermodel.HSSFSimpleShape;
import shadeio.poi.hssf.usermodel.HSSFTextbox;
import shadeio.poi.poifs.filesystem.DirectoryNode;
import shadeio.poi.util.RecordFormatException;

public class HSSFShapeFactory {
    public static void createShapeTree(EscherContainerRecord container, EscherAggregate agg, HSSFShapeContainer out, DirectoryNode root) {
        if (container.getRecordId() == -4093) {
            ObjRecord obj = null;
            EscherClientDataRecord clientData = (EscherClientDataRecord)((EscherContainerRecord)container.getChild(0)).getChildById((short)-4079);
            if (null != clientData) {
                obj = (ObjRecord)agg.getShapeToObjMapping().get(clientData);
            }
            HSSFShapeGroup group = new HSSFShapeGroup(container, obj);
            List<EscherContainerRecord> children = container.getChildContainers();
            for (int i = 0; i < children.size(); ++i) {
                EscherContainerRecord spContainer = children.get(i);
                if (i == 0) continue;
                HSSFShapeFactory.createShapeTree(spContainer, agg, group, root);
            }
            out.addShape(group);
        } else if (container.getRecordId() == -4092) {
            HSSFSimpleShape shape;
            Map<EscherRecord, Record> shapeToObj = agg.getShapeToObjMapping();
            ObjRecord objRecord = null;
            TextObjectRecord txtRecord = null;
            for (EscherRecord record : container) {
                switch (record.getRecordId()) {
                    case -4079: {
                        objRecord = (ObjRecord)shapeToObj.get(record);
                        break;
                    }
                    case -4083: {
                        txtRecord = (TextObjectRecord)shapeToObj.get(record);
                        break;
                    }
                }
            }
            if (objRecord == null) {
                throw new RecordFormatException("EscherClientDataRecord can't be found.");
            }
            if (HSSFShapeFactory.isEmbeddedObject(objRecord)) {
                HSSFObjectData objectData = new HSSFObjectData(container, objRecord, root);
                out.addShape(objectData);
                return;
            }
            CommonObjectDataSubRecord cmo = (CommonObjectDataSubRecord)objRecord.getSubRecords().get(0);
            switch (cmo.getObjectType()) {
                case 8: {
                    shape = new HSSFPicture(container, objRecord);
                    break;
                }
                case 2: {
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                    break;
                }
                case 1: {
                    shape = new HSSFSimpleShape(container, objRecord);
                    break;
                }
                case 20: {
                    shape = new HSSFCombobox(container, objRecord);
                    break;
                }
                case 30: {
                    EscherOptRecord optRecord = (EscherOptRecord)container.getChildById((short)-4085);
                    if (optRecord == null) {
                        shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                        break;
                    }
                    Object property = optRecord.lookup(325);
                    if (null != property) {
                        shape = new HSSFPolygon(container, objRecord, txtRecord);
                        break;
                    }
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                    break;
                }
                case 6: {
                    shape = new HSSFTextbox(container, objRecord, txtRecord);
                    break;
                }
                case 25: {
                    shape = new HSSFComment(container, objRecord, txtRecord, agg.getNoteRecordByObj(objRecord));
                    break;
                }
                default: {
                    shape = new HSSFSimpleShape(container, objRecord, txtRecord);
                }
            }
            out.addShape(shape);
        }
    }

    private static boolean isEmbeddedObject(ObjRecord obj) {
        for (SubRecord sub : obj.getSubRecords()) {
            if (!(sub instanceof EmbeddedObjectRefSubRecord)) continue;
            return true;
        }
        return false;
    }
}

