/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.poifs.crypt.binaryrc4;

import shadeio.poi.EncryptedDocumentException;
import shadeio.poi.poifs.crypt.CipherAlgorithm;
import shadeio.poi.poifs.crypt.EncryptionVerifier;
import shadeio.poi.poifs.crypt.HashAlgorithm;
import shadeio.poi.poifs.crypt.standard.EncryptionRecord;
import shadeio.poi.util.LittleEndianByteArrayOutputStream;
import shadeio.poi.util.LittleEndianInput;

public class BinaryRC4EncryptionVerifier
extends EncryptionVerifier
implements EncryptionRecord,
Cloneable {
    protected BinaryRC4EncryptionVerifier() {
        this.setSpinCount(-1);
        this.setCipherAlgorithm(CipherAlgorithm.rc4);
        this.setChainingMode(null);
        this.setEncryptedKey(null);
        this.setHashAlgorithm(HashAlgorithm.md5);
    }

    protected BinaryRC4EncryptionVerifier(LittleEndianInput is) {
        byte[] salt = new byte[16];
        is.readFully(salt);
        this.setSalt(salt);
        byte[] encryptedVerifier = new byte[16];
        is.readFully(encryptedVerifier);
        this.setEncryptedVerifier(encryptedVerifier);
        byte[] encryptedVerifierHash = new byte[16];
        is.readFully(encryptedVerifierHash);
        this.setEncryptedVerifierHash(encryptedVerifierHash);
        this.setSpinCount(-1);
        this.setCipherAlgorithm(CipherAlgorithm.rc4);
        this.setChainingMode(null);
        this.setEncryptedKey(null);
        this.setHashAlgorithm(HashAlgorithm.md5);
    }

    @Override
    protected void setSalt(byte[] salt) {
        if (salt == null || salt.length != 16) {
            throw new EncryptedDocumentException("invalid verifier salt");
        }
        super.setSalt(salt);
    }

    @Override
    protected void setEncryptedVerifier(byte[] encryptedVerifier) {
        super.setEncryptedVerifier(encryptedVerifier);
    }

    @Override
    protected void setEncryptedVerifierHash(byte[] encryptedVerifierHash) {
        super.setEncryptedVerifierHash(encryptedVerifierHash);
    }

    @Override
    public void write(LittleEndianByteArrayOutputStream bos) {
        byte[] salt = this.getSalt();
        assert (salt.length == 16);
        bos.write(salt);
        byte[] encryptedVerifier = this.getEncryptedVerifier();
        assert (encryptedVerifier.length == 16);
        bos.write(encryptedVerifier);
        byte[] encryptedVerifierHash = this.getEncryptedVerifierHash();
        assert (encryptedVerifierHash.length == 16);
        bos.write(encryptedVerifierHash);
    }

    @Override
    public BinaryRC4EncryptionVerifier clone() throws CloneNotSupportedException {
        return (BinaryRC4EncryptionVerifier)super.clone();
    }
}

