/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.poifs.filesystem;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import shadeio.poi.poifs.common.POIFSConstants;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.LittleEndian;
import shadeio.poi.util.LocaleUtil;

public enum FileMagic {
    OLE2(-2226271756974174256L),
    OOXML(new byte[][]{POIFSConstants.OOXML_FILE_HEADER}),
    XML(new byte[][]{POIFSConstants.RAW_XML_FILE_HEADER}),
    BIFF2(new byte[][]{{9, 0, 4, 0, 0, 0, 112, 0}}),
    BIFF3(new byte[][]{{9, 2, 6, 0, 0, 0, 112, 0}}),
    BIFF4({9, 4, 6, 0, 0, 0, 112, 0}, {9, 4, 6, 0, 0, 0, 0, 1}),
    MSWRITE({49, -66, 0, 0}, {50, -66, 0, 0}),
    RTF("{\\rtf"),
    PDF("%PDF"),
    HTML("<!DOCTYP".getBytes(StandardCharsets.UTF_8), "<html".getBytes(StandardCharsets.UTF_8), "\n\r<html".getBytes(StandardCharsets.UTF_8), "\r\n<html".getBytes(StandardCharsets.UTF_8), "\r<html".getBytes(StandardCharsets.UTF_8), "\n<html".getBytes(StandardCharsets.UTF_8), "<HTML".getBytes(StandardCharsets.UTF_8), "\r\n<HTML".getBytes(StandardCharsets.UTF_8), "\n\r<HTML".getBytes(StandardCharsets.UTF_8), "\r<HTML".getBytes(StandardCharsets.UTF_8), "\n<HTML".getBytes(StandardCharsets.UTF_8)),
    WORD2(new byte[][]{{-37, -91, 45, 0}}),
    UNKNOWN(new byte[][]{new byte[0]});

    final byte[][] magic;

    private FileMagic(long magic) {
        this.magic = new byte[1][8];
        LittleEndian.putLong(this.magic[0], 0, magic);
    }

    private FileMagic(byte[] ... magic) {
        this.magic = magic;
    }

    private FileMagic(String magic) {
        this(new byte[][]{magic.getBytes(LocaleUtil.CHARSET_1252)});
    }

    public static FileMagic valueOf(byte[] magic) {
        for (FileMagic fm : FileMagic.values()) {
            for (byte[] ma : fm.magic) {
                if (!FileMagic.findMagic(ma, magic)) continue;
                return fm;
            }
        }
        return UNKNOWN;
    }

    private static boolean findMagic(byte[] expected, byte[] actual) {
        int i = 0;
        for (byte expectedByte : expected) {
            byte actualByte;
            if ((actualByte = actual[i++]) == expectedByte || expectedByte == 112 && (actualByte == 16 || actualByte == 32 || actualByte == 64)) continue;
            return false;
        }
        return true;
    }

    public static FileMagic valueOf(File inp) throws IOException {
        try (FileInputStream fis = new FileInputStream(inp);){
            byte[] data = IOUtils.toByteArray(fis, 8);
            FileMagic fileMagic = FileMagic.valueOf(data);
            return fileMagic;
        }
    }

    public static FileMagic valueOf(InputStream inp) throws IOException {
        if (!inp.markSupported()) {
            throw new IOException("getFileMagic() only operates on streams which support mark(int)");
        }
        byte[] data = IOUtils.peekFirst8Bytes(inp);
        return FileMagic.valueOf(data);
    }

    public static InputStream prepareToCheckMagic(InputStream stream) {
        if (stream.markSupported()) {
            return stream;
        }
        return new BufferedInputStream(stream);
    }
}

