/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.sl.draw;

import java.awt.BasicStroke;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Rectangle2D;
import java.util.Locale;
import shadeio.poi.sl.draw.Drawable;
import shadeio.poi.sl.usermodel.PlaceableShape;
import shadeio.poi.sl.usermodel.StrokeStyle;

public class DrawShape
implements Drawable {
    protected final shadeio.poi.sl.usermodel.Shape<?, ?> shape;

    public DrawShape(shadeio.poi.sl.usermodel.Shape<?, ?> shape) {
        this.shape = shape;
    }

    static boolean isHSLF(Object shape) {
        return shape.getClass().getName().toLowerCase(Locale.ROOT).contains("hslf");
    }

    @Override
    public void applyTransform(Graphics2D graphics) {
        char[] cmds;
        char[] cArray;
        if (!(this.shape instanceof PlaceableShape) || graphics == null) {
            return;
        }
        PlaceableShape ps = (PlaceableShape)((Object)this.shape);
        boolean isHSLF = DrawShape.isHSLF(this.shape);
        Rectangle2D anchor = DrawShape.getAnchor(graphics, ps);
        if (isHSLF) {
            char[] cArray2 = new char[3];
            cArray2[0] = 104;
            cArray2[1] = 118;
            cArray = cArray2;
            cArray2[2] = 114;
        } else {
            char[] cArray3 = new char[3];
            cArray3[0] = 114;
            cArray3[1] = 104;
            cArray = cArray3;
            cArray3[2] = 118;
        }
        block5: for (char ch : cmds = cArray) {
            switch (ch) {
                case 'h': {
                    if (!ps.getFlipHorizontal()) continue block5;
                    graphics.translate(anchor.getX() + anchor.getWidth(), anchor.getY());
                    graphics.scale(-1.0, 1.0);
                    graphics.translate(-anchor.getX(), -anchor.getY());
                    continue block5;
                }
                case 'v': {
                    if (!ps.getFlipVertical()) continue block5;
                    graphics.translate(anchor.getX(), anchor.getY() + anchor.getHeight());
                    graphics.scale(1.0, -1.0);
                    graphics.translate(-anchor.getX(), -anchor.getY());
                    continue block5;
                }
                case 'r': {
                    double rotation = ps.getRotation();
                    if (rotation == 0.0) continue block5;
                    double centerX = anchor.getCenterX();
                    double centerY = anchor.getCenterY();
                    graphics.translate(centerX, centerY);
                    graphics.rotate(Math.toRadians(rotation));
                    graphics.translate(-centerX, -centerY);
                    continue block5;
                }
                default: {
                    throw new RuntimeException("unexpected transform code " + ch);
                }
            }
        }
    }

    private static double safeScale(double dim1, double dim2) {
        if (dim1 == 0.0) {
            return 1.0;
        }
        return dim2 == 0.0 ? 1.0 : dim1 / dim2;
    }

    @Override
    public void draw(Graphics2D graphics) {
    }

    @Override
    public void drawContent(Graphics2D graphics) {
    }

    public static Rectangle2D getAnchor(Graphics2D graphics, PlaceableShape<?, ?> shape) {
        Rectangle2D normalizedShape;
        double rotation;
        int quadrant;
        AffineTransform tx;
        Rectangle2D shapeAnchor = shape.getAnchor();
        if (shapeAnchor == null) {
            return null;
        }
        boolean isHSLF = DrawShape.isHSLF(shape);
        AffineTransform affineTransform = tx = graphics == null ? null : (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx == null) {
            tx = new AffineTransform();
        }
        if ((quadrant = ((int)(rotation = (shape.getRotation() % 360.0 + 360.0) % 360.0) + 45) / 90 % 4) == 1 || quadrant == 3) {
            Rectangle2D anchorO = tx.createTransformedShape(shapeAnchor).getBounds2D();
            double centerX = anchorO.getCenterX();
            double centerY = anchorO.getCenterY();
            AffineTransform txs2 = new AffineTransform();
            if (!isHSLF) {
                txs2.translate(centerX, centerY);
                txs2.quadrantRotate(1);
                txs2.translate(-centerX, -centerY);
                txs2.concatenate(tx);
            }
            txs2.translate(centerX, centerY);
            txs2.quadrantRotate(3);
            txs2.translate(-centerX, -centerY);
            if (isHSLF) {
                txs2.concatenate(tx);
            }
            Rectangle2D anchorT = txs2.createTransformedShape(shapeAnchor).getBounds2D();
            double scaleX2 = DrawShape.safeScale(anchorO.getWidth(), anchorT.getWidth());
            double scaleY2 = DrawShape.safeScale(anchorO.getHeight(), anchorT.getHeight());
            double centerX2 = shapeAnchor.getCenterX();
            double centerY2 = shapeAnchor.getCenterY();
            AffineTransform txs22 = new AffineTransform();
            txs22.translate(centerX2, centerY2);
            txs22.scale(scaleY2, scaleX2);
            txs22.translate(-centerX2, -centerY2);
            normalizedShape = txs22.createTransformedShape(shapeAnchor).getBounds2D();
        } else {
            normalizedShape = shapeAnchor;
        }
        if (tx.isIdentity()) {
            return normalizedShape;
        }
        Shape anc = tx.createTransformedShape(normalizedShape);
        return anc != null ? anc.getBounds2D() : normalizedShape;
    }

    public static Rectangle2D getAnchor(Graphics2D graphics, Rectangle2D anchor) {
        if (graphics == null) {
            return anchor;
        }
        AffineTransform tx = (AffineTransform)graphics.getRenderingHint(Drawable.GROUP_TRANSFORM);
        if (tx != null && !tx.isIdentity() && tx.createTransformedShape(anchor) != null) {
            anchor = tx.createTransformedShape(anchor).getBounds2D();
        }
        return anchor;
    }

    protected shadeio.poi.sl.usermodel.Shape<?, ?> getShape() {
        return this.shape;
    }

    protected static BasicStroke getStroke(StrokeStyle strokeStyle) {
        int lineCap;
        StrokeStyle.LineCap lineCapE;
        StrokeStyle.LineDash lineDash;
        float lineWidth = (float)strokeStyle.getLineWidth();
        if (lineWidth == 0.0f) {
            lineWidth = 0.25f;
        }
        if ((lineDash = strokeStyle.getLineDash()) == null) {
            lineDash = StrokeStyle.LineDash.SOLID;
        }
        int[] dashPatI = lineDash.pattern;
        float dash_phase = 0.0f;
        float[] dashPatF = null;
        if (dashPatI != null) {
            dashPatF = new float[dashPatI.length];
            for (int i = 0; i < dashPatI.length; ++i) {
                dashPatF[i] = (float)dashPatI[i] * Math.max(1.0f, lineWidth);
            }
        }
        if ((lineCapE = strokeStyle.getLineCap()) == null) {
            lineCapE = StrokeStyle.LineCap.FLAT;
        }
        switch (lineCapE) {
            case ROUND: {
                lineCap = 1;
                break;
            }
            case SQUARE: {
                lineCap = 2;
                break;
            }
            default: {
                lineCap = 0;
            }
        }
        int lineJoin = 1;
        return new BasicStroke(lineWidth, lineCap, lineJoin, lineWidth, dashPatF, 0.0f);
    }
}

