/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.sl.draw;

import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Paint;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Path2D;
import java.awt.geom.Rectangle2D;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBElement;
import javax.xml.bind.Unmarshaller;
import javax.xml.stream.EventFilter;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import shadeio.poi.sl.draw.DrawFactory;
import shadeio.poi.sl.draw.DrawPaint;
import shadeio.poi.sl.draw.DrawShape;
import shadeio.poi.sl.draw.Drawable;
import shadeio.poi.sl.draw.binding.CTCustomGeometry2D;
import shadeio.poi.sl.draw.geom.Context;
import shadeio.poi.sl.draw.geom.CustomGeometry;
import shadeio.poi.sl.draw.geom.IAdjustableShape;
import shadeio.poi.sl.draw.geom.Outline;
import shadeio.poi.sl.draw.geom.Path;
import shadeio.poi.sl.usermodel.LineDecoration;
import shadeio.poi.sl.usermodel.PaintStyle;
import shadeio.poi.sl.usermodel.PlaceableShape;
import shadeio.poi.sl.usermodel.Shadow;
import shadeio.poi.sl.usermodel.SimpleShape;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.StaxHelper;
import shadeio.poi.util.Units;

public class DrawSimpleShape
extends DrawShape {
    private static final double DECO_SIZE_POW = 1.5;

    public DrawSimpleShape(SimpleShape<?, ?> shape) {
        super(shape);
    }

    @Override
    public void draw(Graphics2D graphics) {
        if (DrawSimpleShape.getAnchor(graphics, this.getShape()) == null) {
            return;
        }
        DrawPaint drawPaint = DrawFactory.getInstance(graphics).getPaint((PlaceableShape<?, ?>)((Object)this.getShape()));
        Paint fill = drawPaint.getPaint(graphics, this.getShape().getFillStyle().getPaint());
        Paint line = drawPaint.getPaint(graphics, this.getShape().getStrokeStyle().getPaint());
        BasicStroke stroke = this.getStroke();
        graphics.setStroke(stroke);
        Collection<Outline> elems = this.computeOutlines(graphics);
        this.drawShadow(graphics, elems, fill, line);
        if (fill != null) {
            for (Outline o : elems) {
                Paint fillMod;
                if (!o.getPath().isFilled() || (fillMod = drawPaint.getPaint(graphics, this.getShape().getFillStyle().getPaint(), o.getPath().getFill())) == null) continue;
                graphics.setPaint(fillMod);
                Shape s = o.getOutline();
                graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
                DrawPaint.fillPaintWorkaround(graphics, s);
            }
        }
        this.drawContent(graphics);
        if (line != null) {
            graphics.setPaint(line);
            graphics.setStroke(stroke);
            for (Outline o : elems) {
                if (!o.getPath().isStroked()) continue;
                Shape s = o.getOutline();
                graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
                graphics.draw(s);
            }
        }
        this.drawDecoration(graphics, line, stroke);
    }

    protected void drawDecoration(Graphics2D graphics, Paint line, BasicStroke stroke) {
        Outline tail;
        if (line == null) {
            return;
        }
        graphics.setPaint(line);
        ArrayList<Outline> lst = new ArrayList<Outline>();
        LineDecoration deco = this.getShape().getLineDecoration();
        Outline head = this.getHeadDecoration(graphics, deco, stroke);
        if (head != null) {
            lst.add(head);
        }
        if ((tail = this.getTailDecoration(graphics, deco, stroke)) != null) {
            lst.add(tail);
        }
        for (Outline o : lst) {
            Shape s = o.getOutline();
            Path p = o.getPath();
            graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
            if (p.isFilled()) {
                graphics.fill(s);
            }
            if (!p.isStroked()) continue;
            graphics.draw(s);
        }
    }

    protected Outline getTailDecoration(Graphics2D graphics, LineDecoration deco, BasicStroke stroke) {
        LineDecoration.DecorationSize tailWidth;
        if (deco == null || stroke == null) {
            return null;
        }
        LineDecoration.DecorationSize tailLength = deco.getTailLength();
        if (tailLength == null) {
            tailLength = LineDecoration.DecorationSize.MEDIUM;
        }
        if ((tailWidth = deco.getTailWidth()) == null) {
            tailWidth = LineDecoration.DecorationSize.MEDIUM;
        }
        double lineWidth = Math.max(2.5, (double)stroke.getLineWidth());
        Rectangle2D anchor = DrawSimpleShape.getAnchor(graphics, this.getShape());
        double x2 = anchor.getX() + anchor.getWidth();
        double y2 = anchor.getY() + anchor.getHeight();
        double alpha = Math.atan(anchor.getHeight() / anchor.getWidth());
        AffineTransform at = new AffineTransform();
        Shape tailShape = null;
        Path p = null;
        double scaleY = Math.pow(1.5, (double)tailWidth.ordinal() + 1.0);
        double scaleX = Math.pow(1.5, (double)tailLength.ordinal() + 1.0);
        LineDecoration.DecorationShape tailShapeEnum = deco.getTailShape();
        if (tailShapeEnum == null) {
            return null;
        }
        switch (tailShapeEnum) {
            case OVAL: {
                p = new Path();
                tailShape = new Ellipse2D.Double(0.0, 0.0, lineWidth * scaleX, lineWidth * scaleY);
                Rectangle2D bounds = tailShape.getBounds2D();
                at.translate(x2 - bounds.getWidth() / 2.0, y2 - bounds.getHeight() / 2.0);
                at.rotate(alpha, bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
                break;
            }
            case STEALTH: 
            case ARROW: {
                p = new Path(false, true);
                Path2D.Double arrow = new Path2D.Double();
                arrow.moveTo(-lineWidth * scaleX, -lineWidth * scaleY / 2.0);
                arrow.lineTo(0.0, 0.0);
                arrow.lineTo(-lineWidth * scaleX, lineWidth * scaleY / 2.0);
                tailShape = arrow;
                at.translate(x2, y2);
                at.rotate(alpha);
                break;
            }
            case TRIANGLE: {
                p = new Path();
                Path2D.Double triangle = new Path2D.Double();
                triangle.moveTo(-lineWidth * scaleX, -lineWidth * scaleY / 2.0);
                triangle.lineTo(0.0, 0.0);
                triangle.lineTo(-lineWidth * scaleX, lineWidth * scaleY / 2.0);
                triangle.closePath();
                tailShape = triangle;
                at.translate(x2, y2);
                at.rotate(alpha);
                break;
            }
        }
        if (tailShape != null) {
            tailShape = at.createTransformedShape(tailShape);
        }
        return tailShape == null ? null : new Outline(tailShape, p);
    }

    protected Outline getHeadDecoration(Graphics2D graphics, LineDecoration deco, BasicStroke stroke) {
        LineDecoration.DecorationSize headWidth;
        if (deco == null || stroke == null) {
            return null;
        }
        LineDecoration.DecorationSize headLength = deco.getHeadLength();
        if (headLength == null) {
            headLength = LineDecoration.DecorationSize.MEDIUM;
        }
        if ((headWidth = deco.getHeadWidth()) == null) {
            headWidth = LineDecoration.DecorationSize.MEDIUM;
        }
        double lineWidth = Math.max(2.5, (double)stroke.getLineWidth());
        Rectangle2D anchor = DrawSimpleShape.getAnchor(graphics, this.getShape());
        double x1 = anchor.getX();
        double y1 = anchor.getY();
        double alpha = Math.atan(anchor.getHeight() / anchor.getWidth());
        AffineTransform at = new AffineTransform();
        Shape headShape = null;
        Path p = null;
        double scaleY = Math.pow(1.5, (double)headWidth.ordinal() + 1.0);
        double scaleX = Math.pow(1.5, (double)headLength.ordinal() + 1.0);
        LineDecoration.DecorationShape headShapeEnum = deco.getHeadShape();
        if (headShapeEnum == null) {
            return null;
        }
        switch (headShapeEnum) {
            case OVAL: {
                p = new Path();
                headShape = new Ellipse2D.Double(0.0, 0.0, lineWidth * scaleX, lineWidth * scaleY);
                Rectangle2D bounds = headShape.getBounds2D();
                at.translate(x1 - bounds.getWidth() / 2.0, y1 - bounds.getHeight() / 2.0);
                at.rotate(alpha, bounds.getX() + bounds.getWidth() / 2.0, bounds.getY() + bounds.getHeight() / 2.0);
                break;
            }
            case STEALTH: 
            case ARROW: {
                p = new Path(false, true);
                Path2D.Double arrow = new Path2D.Double();
                arrow.moveTo(lineWidth * scaleX, -lineWidth * scaleY / 2.0);
                arrow.lineTo(0.0, 0.0);
                arrow.lineTo(lineWidth * scaleX, lineWidth * scaleY / 2.0);
                headShape = arrow;
                at.translate(x1, y1);
                at.rotate(alpha);
                break;
            }
            case TRIANGLE: {
                p = new Path();
                Path2D.Double triangle = new Path2D.Double();
                triangle.moveTo(lineWidth * scaleX, -lineWidth * scaleY / 2.0);
                triangle.lineTo(0.0, 0.0);
                triangle.lineTo(lineWidth * scaleX, lineWidth * scaleY / 2.0);
                triangle.closePath();
                headShape = triangle;
                at.translate(x1, y1);
                at.rotate(alpha);
                break;
            }
        }
        if (headShape != null) {
            headShape = at.createTransformedShape(headShape);
        }
        return headShape == null ? null : new Outline(headShape, p);
    }

    public BasicStroke getStroke() {
        return DrawSimpleShape.getStroke(this.getShape().getStrokeStyle());
    }

    protected void drawShadow(Graphics2D graphics, Collection<Outline> outlines, Paint fill, Paint line) {
        Shadow shadow = this.getShape().getShadow();
        if (shadow == null || fill == null && line == null) {
            return;
        }
        PaintStyle.SolidPaint shadowPaint = shadow.getFillStyle();
        Color shadowColor = DrawPaint.applyColorTransform(shadowPaint.getSolidColor());
        double shapeRotation = this.getShape().getRotation();
        if (this.getShape().getFlipVertical()) {
            shapeRotation += 180.0;
        }
        double angle = shadow.getAngle() - shapeRotation;
        double dist = shadow.getDistance();
        double dx = dist * Math.cos(Math.toRadians(angle));
        double dy = dist * Math.sin(Math.toRadians(angle));
        graphics.translate(dx, dy);
        for (Outline o : outlines) {
            Shape s = o.getOutline();
            Path p = o.getPath();
            graphics.setRenderingHint(Drawable.GRADIENT_SHAPE, s);
            graphics.setPaint(shadowColor);
            if (fill != null && p.isFilled()) {
                DrawPaint.fillPaintWorkaround(graphics, s);
                continue;
            }
            if (line == null || !p.isStroked()) continue;
            graphics.draw(s);
        }
        graphics.translate(-dx, -dy);
    }

    protected static CustomGeometry getCustomGeometry(String name) {
        return DrawSimpleShape.getCustomGeometry(name, null);
    }

    protected static CustomGeometry getCustomGeometry(String name, Graphics2D graphics) {
        HashMap<String, CustomGeometry> presets;
        HashMap<String, CustomGeometry> hashMap = presets = graphics == null ? null : (HashMap<String, CustomGeometry>)graphics.getRenderingHint(Drawable.PRESET_GEOMETRY_CACHE);
        if (presets == null) {
            presets = new HashMap<String, CustomGeometry>();
            if (graphics != null) {
                graphics.setRenderingHint(Drawable.PRESET_GEOMETRY_CACHE, presets);
            }
            String packageName = "shadeio.poi.sl.draw.binding";
            InputStream presetIS = Drawable.class.getResourceAsStream("presetShapeDefinitions.xml");
            EventFilter startElementFilter = new EventFilter(){

                @Override
                public boolean accept(XMLEvent event) {
                    return event.isStartElement();
                }
            };
            try {
                XMLInputFactory staxFactory = StaxHelper.newXMLInputFactory();
                XMLEventReader staxReader = staxFactory.createXMLEventReader(presetIS);
                XMLEventReader staxFiltRd = staxFactory.createFilteredReader(staxReader, startElementFilter);
                staxFiltRd.nextEvent();
                JAXBContext jaxbContext = JAXBContext.newInstance((String)packageName);
                Unmarshaller unmarshaller = jaxbContext.createUnmarshaller();
                while (staxFiltRd.peek() != null) {
                    StartElement evRoot = (StartElement)staxFiltRd.peek();
                    String cusName = evRoot.getName().getLocalPart();
                    JAXBElement el = unmarshaller.unmarshal(staxReader, CTCustomGeometry2D.class);
                    CTCustomGeometry2D cusGeom = (CTCustomGeometry2D)el.getValue();
                    presets.put(cusName, new CustomGeometry(cusGeom));
                }
                staxFiltRd.close();
                staxReader.close();
            }
            catch (Exception e) {
                throw new RuntimeException("Unable to load preset geometries.", e);
            }
            finally {
                IOUtils.closeQuietly(presetIS);
            }
        }
        return (CustomGeometry)presets.get(name);
    }

    protected Collection<Outline> computeOutlines(Graphics2D graphics) {
        shadeio.poi.sl.usermodel.Shape sh = this.getShape();
        ArrayList<Outline> lst = new ArrayList<Outline>();
        CustomGeometry geom = sh.getGeometry();
        if (geom == null) {
            return lst;
        }
        Rectangle2D anchor = DrawSimpleShape.getAnchor(graphics, sh);
        if (anchor == null) {
            return lst;
        }
        for (Path p : geom) {
            double scaleY;
            double scaleX;
            double w = p.getW();
            double h = p.getH();
            if (w == -1.0) {
                w = Units.toEMU(anchor.getWidth());
                scaleX = Units.toPoints(1L);
            } else {
                scaleX = anchor.getWidth() == 0.0 ? 1.0 : anchor.getWidth() / w;
            }
            if (h == -1.0) {
                h = Units.toEMU(anchor.getHeight());
                scaleY = Units.toPoints(1L);
            } else {
                scaleY = anchor.getHeight() == 0.0 ? 1.0 : anchor.getHeight() / h;
            }
            Rectangle2D.Double pathAnchor = new Rectangle2D.Double(0.0, 0.0, w, h);
            Context ctx = new Context(geom, pathAnchor, (IAdjustableShape)((Object)sh));
            Path2D.Double gp = p.getPath(ctx);
            AffineTransform at = new AffineTransform();
            at.translate(anchor.getX(), anchor.getY());
            at.scale(scaleX, scaleY);
            Shape canvasShape = at.createTransformedShape(gp);
            lst.add(new Outline(canvasShape, p));
        }
        return lst;
    }

    protected SimpleShape<?, ?> getShape() {
        return (SimpleShape)this.shape;
    }
}

