/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xdgf.usermodel;

import com.microsoft.schemas.office.visio.x2012.main.MasterType;
import com.microsoft.schemas.office.visio.x2012.main.MastersDocument;
import com.microsoft.schemas.office.visio.x2012.main.MastersType;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import org.apache.xmlbeans.XmlException;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.util.Internal;
import shadeio.poi.xdgf.exceptions.XDGFException;
import shadeio.poi.xdgf.usermodel.XDGFDocument;
import shadeio.poi.xdgf.usermodel.XDGFMaster;
import shadeio.poi.xdgf.usermodel.XDGFMasterContents;
import shadeio.poi.xdgf.xml.XDGFXMLDocumentPart;

public class XDGFMasters
extends XDGFXMLDocumentPart {
    MastersType _mastersObject;
    protected Map<Long, XDGFMaster> _masters = new HashMap<Long, XDGFMaster>();

    public XDGFMasters(PackagePart part, XDGFDocument document) {
        super(part, document);
    }

    @Internal
    protected MastersType getXmlObject() {
        return this._mastersObject;
    }

    @Override
    protected void onDocumentRead() {
        try {
            try {
                this._mastersObject = MastersDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream()).getMasters();
            }
            catch (IOException | XmlException e) {
                throw new POIXMLException(e);
            }
            HashMap<String, MasterType> masterSettings = new HashMap<String, MasterType>();
            for (MasterType master : this._mastersObject.getMasterArray()) {
                masterSettings.put(master.getRel().getId(), master);
            }
            for (POIXMLDocumentPart.RelationPart rp : this.getRelationParts()) {
                Object part = rp.getDocumentPart();
                String relId = rp.getRelationship().getId();
                MasterType settings = (MasterType)masterSettings.get(relId);
                if (settings == null) {
                    throw new POIXMLException("Master relationship for " + relId + " not found");
                }
                if (!(part instanceof XDGFMasterContents)) {
                    throw new POIXMLException("Unexpected masters relationship for " + relId + ": " + part);
                }
                XDGFMasterContents contents = (XDGFMasterContents)part;
                contents.onDocumentRead();
                XDGFMaster master = new XDGFMaster(settings, contents, this._document);
                this._masters.put(master.getID(), master);
            }
        }
        catch (POIXMLException e) {
            throw XDGFException.wrap(this, e);
        }
    }

    public Collection<XDGFMaster> getMastersList() {
        return Collections.unmodifiableCollection(this._masters.values());
    }

    public XDGFMaster getMasterById(long masterId) {
        return this._masters.get(masterId);
    }
}

