/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xdgf.usermodel.section.geometry;

import com.microsoft.schemas.office.visio.x2012.main.CellType;
import com.microsoft.schemas.office.visio.x2012.main.RowType;
import java.awt.geom.Path2D;
import shadeio.poi.ooxml.POIXMLException;
import shadeio.poi.xdgf.usermodel.XDGFCell;
import shadeio.poi.xdgf.usermodel.XDGFShape;
import shadeio.poi.xdgf.usermodel.section.geometry.EllipticalArcTo;
import shadeio.poi.xdgf.usermodel.section.geometry.GeometryRow;

public class RelEllipticalArcTo
implements GeometryRow {
    RelEllipticalArcTo _master;
    Double x;
    Double y;
    Double a;
    Double b;
    Double c;
    Double d;
    Boolean deleted;

    public RelEllipticalArcTo(RowType row) {
        if (row.isSetDel()) {
            this.deleted = row.getDel();
        }
        for (CellType cell : row.getCellArray()) {
            String cellName = cell.getN();
            if (cellName.equals("X")) {
                this.x = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("Y")) {
                this.y = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("A")) {
                this.a = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("B")) {
                this.b = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("C")) {
                this.c = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            if (cellName.equals("D")) {
                this.d = XDGFCell.parseDoubleValue(cell);
                continue;
            }
            throw new POIXMLException("Invalid cell '" + cellName + "' in RelEllipticalArcTo row");
        }
    }

    public boolean getDel() {
        if (this.deleted != null) {
            return this.deleted;
        }
        return this._master != null && this._master.getDel();
    }

    public Double getX() {
        return this.x == null ? this._master.x : this.x;
    }

    public Double getY() {
        return this.y == null ? this._master.y : this.y;
    }

    public Double getA() {
        return this.a == null ? this._master.a : this.a;
    }

    public Double getB() {
        return this.b == null ? this._master.b : this.b;
    }

    public Double getC() {
        return this.c == null ? this._master.c : this.c;
    }

    public Double getD() {
        return this.d == null ? this._master.d : this.d;
    }

    @Override
    public void setupMaster(GeometryRow row) {
        this._master = (RelEllipticalArcTo)row;
    }

    @Override
    public void addToPath(Path2D.Double path, XDGFShape parent) {
        if (this.getDel()) {
            return;
        }
        double w = parent.getWidth();
        double h = parent.getHeight();
        double x = this.getX() * w;
        double y = this.getY() * h;
        double a = this.getA() * w;
        double b = this.getB() * h;
        double c = this.getC();
        double d = this.getD();
        EllipticalArcTo.createEllipticalArc(x, y, a, b, c, d, path);
    }
}

