/*
 * Decompiled with CFR 0.152.
 */
package shadeio.spoiwo.natures.csv;

import java.io.Serializable;
import java.util.Calendar;
import java.util.Date;
import org.joda.time.LocalDate;
import scala.Function0;
import scala.Function1;
import scala.Predef;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Iterable$;
import scala.collection.TraversableOnce;
import scala.collection.immutable.List$;
import scala.collection.immutable.Map;
import scala.runtime.BoxesRunTime;
import shadeio.spoiwo.model.BlankCell;
import shadeio.spoiwo.model.BooleanCell;
import shadeio.spoiwo.model.CalendarCell;
import shadeio.spoiwo.model.Cell;
import shadeio.spoiwo.model.DateCell;
import shadeio.spoiwo.model.HyperLinkUrlCell;
import shadeio.spoiwo.model.NumericCell;
import shadeio.spoiwo.model.Row;
import shadeio.spoiwo.model.Sheet;
import shadeio.spoiwo.model.StringCell;
import shadeio.spoiwo.model.Workbook;
import shadeio.spoiwo.natures.csv.CsvProperties;
import shadeio.spoiwo.natures.csv.Model2CsvConversions;

public final class Model2CsvConversions$ {
    public static Model2CsvConversions$ MODULE$;

    static {
        new Model2CsvConversions$();
    }

    public Model2CsvConversions.CsvWorkbook CsvWorkbook(Workbook wb) {
        return new Model2CsvConversions.CsvWorkbook(wb);
    }

    public Model2CsvConversions.CsvSheet CsvSheet(Sheet s) {
        return new Model2CsvConversions.CsvSheet(s);
    }

    public Map<String, String> com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertWorkbookToCsv(Workbook wb, CsvProperties properties) {
        Predef$.MODULE$.require(wb.sheets().size() <= 1 || wb.sheets().forall((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)Model2CsvConversions$.$anonfun$convertWorkbookToCsv$1(x$1))), (Function0 & Serializable & scala.Serializable)() -> "When converting workbook with multiple sheets to CSV format it is required to specify the unique name for each of them!");
        return ((TraversableOnce)wb.sheets().map((Function1 & Serializable & scala.Serializable)s -> MODULE$.com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertSheetToCsv((Sheet)s, properties), Iterable$.MODULE$.canBuildFrom())).toMap(Predef$.MODULE$.$conforms());
    }

    public Tuple2<String, String> com$norbitltd$spoiwo$natures$csv$Model2CsvConversions$$convertSheetToCsv(Sheet s, CsvProperties properties) {
        return Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc(s.name().getOrElse((Function0 & Serializable & scala.Serializable)() -> "")), (Object)((TraversableOnce)s.rows().map((Function1 & Serializable & scala.Serializable)r -> MODULE$.convertRowToCsv((Row)r, properties), List$.MODULE$.canBuildFrom())).mkString("\n"));
    }

    private String convertRowToCsv(Row r, CsvProperties properties) {
        return ((TraversableOnce)r.cells().map((Function1 & Serializable & scala.Serializable)c -> MODULE$.convertCellToCsv((Cell)c, properties), Iterable$.MODULE$.canBuildFrom())).mkString(properties.separator());
    }

    private String convertCellToCsv(Cell c, CsvProperties properties) {
        String string;
        Cell cell = c;
        if (cell instanceof BlankCell) {
            string = "";
        } else if (cell instanceof StringCell) {
            StringCell stringCell = (StringCell)cell;
            string = stringCell.value();
        } else if (cell instanceof NumericCell) {
            NumericCell numericCell = (NumericCell)cell;
            string = ((Object)BoxesRunTime.boxToDouble((double)numericCell.value())).toString();
        } else if (cell instanceof BooleanCell) {
            BooleanCell booleanCell = (BooleanCell)cell;
            string = booleanCell.value() ? properties.defaultBooleanTrueString() : properties.defaultBooleanFalseString();
        } else if (cell instanceof DateCell) {
            DateCell dateCell = (DateCell)cell;
            string = LocalDate.fromDateFields((Date)dateCell.value()).toString(properties.defaultDateFormat());
        } else if (cell instanceof CalendarCell) {
            CalendarCell calendarCell = (CalendarCell)cell;
            string = LocalDate.fromCalendarFields((Calendar)calendarCell.value()).toString(properties.defaultDateFormat());
        } else if (cell instanceof HyperLinkUrlCell) {
            HyperLinkUrlCell hyperLinkUrlCell = (HyperLinkUrlCell)cell;
            string = hyperLinkUrlCell.value().text();
        } else {
            throw new IllegalArgumentException(new StringBuilder(42).append("Unable to convert to CSV cell for value: ").append(cell).append("!").toString());
        }
        return string;
    }

    public static final /* synthetic */ boolean $anonfun$convertWorkbookToCsv$1(Sheet x$1) {
        return x$1.name().isDefined();
    }

    private Model2CsvConversions$() {
        MODULE$ = this;
    }
}

