/*
 * Decompiled with CFR 0.152.
 */
package shadeio.pjfanning.xlsx.impl;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.security.GeneralSecurityException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import shadeio.pjfanning.poi.xssf.streaming.TempFileSharedStringsTable;
import shadeio.pjfanning.xlsx.StreamingReader;
import shadeio.pjfanning.xlsx.XmlUtils;
import shadeio.pjfanning.xlsx.exceptions.NotSupportedException;
import shadeio.pjfanning.xlsx.exceptions.OpenException;
import shadeio.pjfanning.xlsx.exceptions.ParseException;
import shadeio.pjfanning.xlsx.exceptions.ReadException;
import shadeio.pjfanning.xlsx.impl.StreamingSheet;
import shadeio.pjfanning.xlsx.impl.StreamingSheetReader;
import shadeio.pjfanning.xlsx.impl.StreamingWorkbook;
import shadeio.pjfanning.xlsx.impl.TempFileUtil;
import shadeio.poi.ooxml.POIXMLProperties;
import shadeio.poi.openxml4j.exceptions.InvalidFormatException;
import shadeio.poi.openxml4j.exceptions.OpenXML4JException;
import shadeio.poi.openxml4j.opc.OPCPackage;
import shadeio.poi.poifs.crypt.Decryptor;
import shadeio.poi.poifs.crypt.EncryptionInfo;
import shadeio.poi.poifs.filesystem.POIFSFileSystem;
import shadeio.poi.ss.usermodel.Sheet;
import shadeio.poi.util.StaxHelper;
import shadeio.poi.xssf.eventusermodel.XSSFReader;
import shadeio.poi.xssf.model.SharedStringsTable;
import shadeio.poi.xssf.model.StylesTable;

public class StreamingWorkbookReader
implements Iterable<Sheet>,
AutoCloseable {
    private static final Logger log = LoggerFactory.getLogger(StreamingWorkbookReader.class);
    private final List<StreamingSheet> sheets;
    private final List<Map<String, String>> sheetProperties = new ArrayList<Map<String, String>>();
    private final StreamingReader.Builder builder;
    private File tmp;
    private OPCPackage pkg;
    private SharedStringsTable sst;
    private boolean use1904Dates = false;
    private StreamingWorkbook workbook = null;
    private POIXMLProperties.CoreProperties coreProperties = null;

    @Deprecated
    public StreamingWorkbookReader(SharedStringsTable sst, OPCPackage pkg, StreamingSheetReader reader, StreamingReader.Builder builder) {
        this.sst = sst;
        this.pkg = pkg;
        this.sheets = Arrays.asList(new StreamingSheet(null, null, reader));
        this.builder = builder;
    }

    public StreamingWorkbookReader(StreamingReader.Builder builder) {
        this.sheets = new ArrayList<StreamingSheet>();
        this.builder = builder;
    }

    public StreamingSheetReader first() {
        return this.sheets.get(0).getReader();
    }

    public void init(InputStream is) {
        File f = null;
        try {
            f = TempFileUtil.writeInputStreamToFile(is, this.builder.getBufferSize());
            log.debug("Created temp file [" + f.getAbsolutePath() + "]");
            this.init(f);
            this.tmp = f;
        }
        catch (IOException e) {
            throw new ReadException("Unable to read input stream", e);
        }
        catch (RuntimeException e) {
            if (f != null) {
                f.delete();
            }
            throw e;
        }
    }

    public void init(File f) {
        try {
            Node date1904;
            if (this.builder.getPassword() != null) {
                POIFSFileSystem poifs = new POIFSFileSystem(f);
                EncryptionInfo info = new EncryptionInfo(poifs);
                Decryptor d = Decryptor.getInstance(info);
                d.verifyPassword(this.builder.getPassword());
                this.pkg = OPCPackage.open(d.getDataStream(poifs));
            } else {
                this.pkg = OPCPackage.open(f);
            }
            XSSFReader reader = new XSSFReader(this.pkg);
            if (this.builder.useSstTempFile()) {
                log.debug("Created sst cache file");
                this.sst = new TempFileSharedStringsTable(this.pkg, this.builder.encryptSstTempFile());
            } else {
                this.sst = reader.getSharedStringsTable();
            }
            if (this.builder.readCoreProperties()) {
                try {
                    POIXMLProperties xmlProperties = new POIXMLProperties(this.pkg);
                    this.coreProperties = xmlProperties.getCoreProperties();
                }
                catch (Exception e) {
                    log.warn("Failed to read coreProperties", (Throwable)e);
                }
            }
            StylesTable styles = reader.getStylesTable();
            NodeList workbookPr = XmlUtils.searchForNodeList(XmlUtils.readDocument(reader.getWorkbookData()), "/ss:workbook/ss:workbookPr");
            if (workbookPr.getLength() == 1 && (date1904 = workbookPr.item(0).getAttributes().getNamedItem("date1904")) != null) {
                this.use1904Dates = XmlUtils.evaluateBoolean(date1904.getTextContent());
            }
            this.loadSheets(reader, this.sst, styles, this.builder.getRowCacheSize());
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new ParseException("Failed to parse file", e);
        }
        catch (IOException e) {
            throw new OpenException("Failed to open file", e);
        }
        catch (XMLStreamException | OpenXML4JException e) {
            throw new ReadException("Unable to read workbook", e);
        }
        catch (GeneralSecurityException e) {
            throw new ReadException("Unable to read workbook - Decryption failed", e);
        }
    }

    void setWorkbook(StreamingWorkbook workbook) {
        this.workbook = workbook;
        workbook.setCoreProperties(this.coreProperties);
    }

    void loadSheets(XSSFReader reader, SharedStringsTable sst, StylesTable stylesTable, int rowCacheSize) throws IOException, InvalidFormatException, XMLStreamException {
        this.lookupSheetNames(reader);
        XSSFReader.SheetIterator iter = (XSSFReader.SheetIterator)reader.getSheetsData();
        LinkedHashMap<URI, InputStream> sheetStreams = new LinkedHashMap<URI, InputStream>();
        while (iter.hasNext()) {
            InputStream is = iter.next();
            sheetStreams.put(iter.getSheetPart().getPartName().getURI(), is);
        }
        int i = 0;
        for (URI uri : sheetStreams.keySet()) {
            XMLEventReader parser = StaxHelper.newXMLInputFactory().createXMLEventReader((InputStream)sheetStreams.get(uri));
            this.sheets.add(new StreamingSheet(this.workbook, this.sheetProperties.get(i++).get("name"), new StreamingSheetReader(sst, stylesTable, parser, this.use1904Dates, rowCacheSize)));
        }
    }

    void lookupSheetNames(XSSFReader reader) throws IOException, InvalidFormatException {
        this.sheetProperties.clear();
        try {
            NodeList nl = XmlUtils.searchForNodeList(XmlUtils.readDocument(reader.getWorkbookData()), "/ss:workbook/ss:sheets/ss:sheet");
            for (int i = 0; i < nl.getLength(); ++i) {
                HashMap<String, String> props = new HashMap<String, String>();
                props.put("name", nl.item(i).getAttributes().getNamedItem("name").getTextContent());
                Node state = nl.item(i).getAttributes().getNamedItem("state");
                props.put("state", state == null ? "visible" : state.getTextContent());
                this.sheetProperties.add(props);
            }
        }
        catch (ParserConfigurationException | SAXException e) {
            throw new ParseException("Failed to parse file", e);
        }
    }

    List<? extends Sheet> getSheets() {
        return this.sheets;
    }

    public List<Map<String, String>> getSheetProperties() {
        return this.sheetProperties;
    }

    @Override
    public Iterator<Sheet> iterator() {
        return new StreamingSheetIterator(this.sheets.iterator());
    }

    @Override
    public void close() throws IOException {
        try {
            for (StreamingSheet sheet : this.sheets) {
                sheet.getReader().close();
            }
            this.pkg.revert();
        }
        finally {
            if (this.tmp != null) {
                if (log.isDebugEnabled()) {
                    log.debug("Deleting tmp file [" + this.tmp.getAbsolutePath() + "]");
                }
                this.tmp.delete();
            }
            if (this.sst != null) {
                this.sst.close();
            }
        }
    }

    static class StreamingSheetIterator
    implements Iterator<Sheet> {
        private final Iterator<StreamingSheet> iterator;

        public StreamingSheetIterator(Iterator<StreamingSheet> iterator) {
            this.iterator = iterator;
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasNext();
        }

        @Override
        public Sheet next() {
            return this.iterator.next();
        }

        @Override
        public void remove() {
            throw new NotSupportedException();
        }
    }
}

