/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record;

import shadeio.poi.hssf.record.SubRecord;
import shadeio.poi.util.HexDump;
import shadeio.poi.util.IOUtils;
import shadeio.poi.util.LittleEndianInput;
import shadeio.poi.util.LittleEndianOutput;
import shadeio.poi.util.Removal;

public final class GroupMarkerSubRecord
extends SubRecord {
    public static final short sid = 6;
    private static final int MAX_RECORD_LENGTH = 100000;
    private static final byte[] EMPTY_BYTE_ARRAY = new byte[0];
    private byte[] reserved;

    public GroupMarkerSubRecord() {
        this.reserved = EMPTY_BYTE_ARRAY;
    }

    public GroupMarkerSubRecord(GroupMarkerSubRecord other) {
        super(other);
        this.reserved = (byte[])other.reserved.clone();
    }

    public GroupMarkerSubRecord(LittleEndianInput in, int size) {
        byte[] buf = IOUtils.safelyAllocate(size, 100000);
        in.readFully(buf);
        this.reserved = buf;
    }

    public String toString() {
        StringBuilder buffer = new StringBuilder();
        String nl = System.getProperty("line.separator");
        buffer.append("[ftGmo]" + nl);
        buffer.append("  reserved = ").append(HexDump.toHex(this.reserved)).append(nl);
        buffer.append("[/ftGmo]" + nl);
        return buffer.toString();
    }

    @Override
    public void serialize(LittleEndianOutput out) {
        out.writeShort(6);
        out.writeShort(this.reserved.length);
        out.write(this.reserved);
    }

    @Override
    protected int getDataSize() {
        return this.reserved.length;
    }

    public short getSid() {
        return 6;
    }

    @Override
    @Deprecated
    @Removal(version="5.0.0")
    public GroupMarkerSubRecord clone() {
        return this.copy();
    }

    @Override
    public GroupMarkerSubRecord copy() {
        return new GroupMarkerSubRecord(this);
    }
}

