/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.hssf.record;

import java.io.InputStream;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import shadeio.poi.EncryptedDocumentException;
import shadeio.poi.hssf.record.ArrayRecord;
import shadeio.poi.hssf.record.AutoFilterInfoRecord;
import shadeio.poi.hssf.record.BOFRecord;
import shadeio.poi.hssf.record.BackupRecord;
import shadeio.poi.hssf.record.BlankRecord;
import shadeio.poi.hssf.record.BookBoolRecord;
import shadeio.poi.hssf.record.BoolErrRecord;
import shadeio.poi.hssf.record.BottomMarginRecord;
import shadeio.poi.hssf.record.BoundSheetRecord;
import shadeio.poi.hssf.record.CFHeader12Record;
import shadeio.poi.hssf.record.CFHeaderRecord;
import shadeio.poi.hssf.record.CFRule12Record;
import shadeio.poi.hssf.record.CFRuleRecord;
import shadeio.poi.hssf.record.CRNCountRecord;
import shadeio.poi.hssf.record.CRNRecord;
import shadeio.poi.hssf.record.CalcCountRecord;
import shadeio.poi.hssf.record.CalcModeRecord;
import shadeio.poi.hssf.record.CodepageRecord;
import shadeio.poi.hssf.record.ColumnInfoRecord;
import shadeio.poi.hssf.record.ContinueRecord;
import shadeio.poi.hssf.record.CountryRecord;
import shadeio.poi.hssf.record.DBCellRecord;
import shadeio.poi.hssf.record.DConRefRecord;
import shadeio.poi.hssf.record.DSFRecord;
import shadeio.poi.hssf.record.DVALRecord;
import shadeio.poi.hssf.record.DVRecord;
import shadeio.poi.hssf.record.DateWindow1904Record;
import shadeio.poi.hssf.record.DefaultColWidthRecord;
import shadeio.poi.hssf.record.DefaultRowHeightRecord;
import shadeio.poi.hssf.record.DeltaRecord;
import shadeio.poi.hssf.record.DimensionsRecord;
import shadeio.poi.hssf.record.DrawingGroupRecord;
import shadeio.poi.hssf.record.DrawingRecord;
import shadeio.poi.hssf.record.DrawingSelectionRecord;
import shadeio.poi.hssf.record.EOFRecord;
import shadeio.poi.hssf.record.ExtSSTRecord;
import shadeio.poi.hssf.record.ExtendedFormatRecord;
import shadeio.poi.hssf.record.ExternSheetRecord;
import shadeio.poi.hssf.record.ExternalNameRecord;
import shadeio.poi.hssf.record.FeatHdrRecord;
import shadeio.poi.hssf.record.FeatRecord;
import shadeio.poi.hssf.record.FilePassRecord;
import shadeio.poi.hssf.record.FileSharingRecord;
import shadeio.poi.hssf.record.FnGroupCountRecord;
import shadeio.poi.hssf.record.FontRecord;
import shadeio.poi.hssf.record.FooterRecord;
import shadeio.poi.hssf.record.FormatRecord;
import shadeio.poi.hssf.record.FormulaRecord;
import shadeio.poi.hssf.record.GridsetRecord;
import shadeio.poi.hssf.record.GutsRecord;
import shadeio.poi.hssf.record.HCenterRecord;
import shadeio.poi.hssf.record.HeaderFooterRecord;
import shadeio.poi.hssf.record.HeaderRecord;
import shadeio.poi.hssf.record.HideObjRecord;
import shadeio.poi.hssf.record.HorizontalPageBreakRecord;
import shadeio.poi.hssf.record.HyperlinkRecord;
import shadeio.poi.hssf.record.IndexRecord;
import shadeio.poi.hssf.record.InterfaceEndRecord;
import shadeio.poi.hssf.record.InterfaceHdrRecord;
import shadeio.poi.hssf.record.IterationRecord;
import shadeio.poi.hssf.record.LabelRecord;
import shadeio.poi.hssf.record.LabelSSTRecord;
import shadeio.poi.hssf.record.LeftMarginRecord;
import shadeio.poi.hssf.record.MMSRecord;
import shadeio.poi.hssf.record.MergeCellsRecord;
import shadeio.poi.hssf.record.MulBlankRecord;
import shadeio.poi.hssf.record.MulRKRecord;
import shadeio.poi.hssf.record.NameCommentRecord;
import shadeio.poi.hssf.record.NameRecord;
import shadeio.poi.hssf.record.NoteRecord;
import shadeio.poi.hssf.record.NumberRecord;
import shadeio.poi.hssf.record.ObjRecord;
import shadeio.poi.hssf.record.ObjectProtectRecord;
import shadeio.poi.hssf.record.PaletteRecord;
import shadeio.poi.hssf.record.PaneRecord;
import shadeio.poi.hssf.record.PasswordRecord;
import shadeio.poi.hssf.record.PasswordRev4Record;
import shadeio.poi.hssf.record.PrecisionRecord;
import shadeio.poi.hssf.record.PrintGridlinesRecord;
import shadeio.poi.hssf.record.PrintHeadersRecord;
import shadeio.poi.hssf.record.PrintSetupRecord;
import shadeio.poi.hssf.record.ProtectRecord;
import shadeio.poi.hssf.record.ProtectionRev4Record;
import shadeio.poi.hssf.record.RKRecord;
import shadeio.poi.hssf.record.RecalcIdRecord;
import shadeio.poi.hssf.record.Record;
import shadeio.poi.hssf.record.RecordFactoryInputStream;
import shadeio.poi.hssf.record.RecordInputStream;
import shadeio.poi.hssf.record.RefModeRecord;
import shadeio.poi.hssf.record.RefreshAllRecord;
import shadeio.poi.hssf.record.RightMarginRecord;
import shadeio.poi.hssf.record.RowRecord;
import shadeio.poi.hssf.record.SSTRecord;
import shadeio.poi.hssf.record.SaveRecalcRecord;
import shadeio.poi.hssf.record.ScenarioProtectRecord;
import shadeio.poi.hssf.record.SelectionRecord;
import shadeio.poi.hssf.record.SharedFormulaRecord;
import shadeio.poi.hssf.record.StringRecord;
import shadeio.poi.hssf.record.StyleRecord;
import shadeio.poi.hssf.record.SupBookRecord;
import shadeio.poi.hssf.record.TabIdRecord;
import shadeio.poi.hssf.record.TableRecord;
import shadeio.poi.hssf.record.TableStylesRecord;
import shadeio.poi.hssf.record.TextObjectRecord;
import shadeio.poi.hssf.record.TopMarginRecord;
import shadeio.poi.hssf.record.UncalcedRecord;
import shadeio.poi.hssf.record.UnknownRecord;
import shadeio.poi.hssf.record.UseSelFSRecord;
import shadeio.poi.hssf.record.UserSViewBegin;
import shadeio.poi.hssf.record.UserSViewEnd;
import shadeio.poi.hssf.record.VCenterRecord;
import shadeio.poi.hssf.record.VerticalPageBreakRecord;
import shadeio.poi.hssf.record.WSBoolRecord;
import shadeio.poi.hssf.record.WindowOneRecord;
import shadeio.poi.hssf.record.WindowProtectRecord;
import shadeio.poi.hssf.record.WindowTwoRecord;
import shadeio.poi.hssf.record.WriteAccessRecord;
import shadeio.poi.hssf.record.WriteProtectRecord;
import shadeio.poi.hssf.record.chart.BeginRecord;
import shadeio.poi.hssf.record.chart.CatLabRecord;
import shadeio.poi.hssf.record.chart.ChartEndBlockRecord;
import shadeio.poi.hssf.record.chart.ChartEndObjectRecord;
import shadeio.poi.hssf.record.chart.ChartFRTInfoRecord;
import shadeio.poi.hssf.record.chart.ChartRecord;
import shadeio.poi.hssf.record.chart.ChartStartBlockRecord;
import shadeio.poi.hssf.record.chart.ChartStartObjectRecord;
import shadeio.poi.hssf.record.chart.ChartTitleFormatRecord;
import shadeio.poi.hssf.record.chart.DataFormatRecord;
import shadeio.poi.hssf.record.chart.EndRecord;
import shadeio.poi.hssf.record.chart.LegendRecord;
import shadeio.poi.hssf.record.chart.LinkedDataRecord;
import shadeio.poi.hssf.record.chart.SeriesRecord;
import shadeio.poi.hssf.record.chart.SeriesTextRecord;
import shadeio.poi.hssf.record.chart.SeriesToChartGroupRecord;
import shadeio.poi.hssf.record.chart.ValueRangeRecord;
import shadeio.poi.hssf.record.pivottable.DataItemRecord;
import shadeio.poi.hssf.record.pivottable.ExtendedPivotTableViewFieldsRecord;
import shadeio.poi.hssf.record.pivottable.PageItemRecord;
import shadeio.poi.hssf.record.pivottable.StreamIDRecord;
import shadeio.poi.hssf.record.pivottable.ViewDefinitionRecord;
import shadeio.poi.hssf.record.pivottable.ViewFieldsRecord;
import shadeio.poi.hssf.record.pivottable.ViewSourceRecord;
import shadeio.poi.util.RecordFormatException;

public final class RecordFactory {
    private static final int NUM_RECORDS = 512;
    private static final Class<?>[] CONSTRUCTOR_ARGS = new Class[]{RecordInputStream.class};
    private static final Class<? extends Record>[] recordClasses = new Class[]{ArrayRecord.class, AutoFilterInfoRecord.class, BackupRecord.class, BlankRecord.class, BOFRecord.class, BookBoolRecord.class, BoolErrRecord.class, BottomMarginRecord.class, BoundSheetRecord.class, CalcCountRecord.class, CalcModeRecord.class, CFHeaderRecord.class, CFHeader12Record.class, CFRuleRecord.class, CFRule12Record.class, ChartRecord.class, ChartTitleFormatRecord.class, CodepageRecord.class, ColumnInfoRecord.class, ContinueRecord.class, CountryRecord.class, CRNCountRecord.class, CRNRecord.class, DateWindow1904Record.class, DBCellRecord.class, DConRefRecord.class, DefaultColWidthRecord.class, DefaultRowHeightRecord.class, DeltaRecord.class, DimensionsRecord.class, DrawingGroupRecord.class, DrawingRecord.class, DrawingSelectionRecord.class, DSFRecord.class, DVALRecord.class, DVRecord.class, EOFRecord.class, ExtendedFormatRecord.class, ExternalNameRecord.class, ExternSheetRecord.class, ExtSSTRecord.class, FeatRecord.class, FeatHdrRecord.class, FilePassRecord.class, FileSharingRecord.class, FnGroupCountRecord.class, FontRecord.class, FooterRecord.class, FormatRecord.class, FormulaRecord.class, GridsetRecord.class, GutsRecord.class, HCenterRecord.class, HeaderRecord.class, HeaderFooterRecord.class, HideObjRecord.class, HorizontalPageBreakRecord.class, HyperlinkRecord.class, IndexRecord.class, InterfaceEndRecord.class, InterfaceHdrRecord.class, IterationRecord.class, LabelRecord.class, LabelSSTRecord.class, LeftMarginRecord.class, LegendRecord.class, MergeCellsRecord.class, MMSRecord.class, MulBlankRecord.class, MulRKRecord.class, NameRecord.class, NameCommentRecord.class, NoteRecord.class, NumberRecord.class, ObjectProtectRecord.class, ObjRecord.class, PaletteRecord.class, PaneRecord.class, PasswordRecord.class, PasswordRev4Record.class, PrecisionRecord.class, PrintGridlinesRecord.class, PrintHeadersRecord.class, PrintSetupRecord.class, ProtectionRev4Record.class, ProtectRecord.class, RecalcIdRecord.class, RefModeRecord.class, RefreshAllRecord.class, RightMarginRecord.class, RKRecord.class, RowRecord.class, SaveRecalcRecord.class, ScenarioProtectRecord.class, SelectionRecord.class, SeriesRecord.class, SeriesTextRecord.class, SharedFormulaRecord.class, SSTRecord.class, StringRecord.class, StyleRecord.class, SupBookRecord.class, TabIdRecord.class, TableRecord.class, TableStylesRecord.class, TextObjectRecord.class, TopMarginRecord.class, UncalcedRecord.class, UseSelFSRecord.class, UserSViewBegin.class, UserSViewEnd.class, ValueRangeRecord.class, VCenterRecord.class, VerticalPageBreakRecord.class, WindowOneRecord.class, WindowProtectRecord.class, WindowTwoRecord.class, WriteAccessRecord.class, WriteProtectRecord.class, WSBoolRecord.class, BeginRecord.class, ChartFRTInfoRecord.class, ChartStartBlockRecord.class, ChartEndBlockRecord.class, ChartStartObjectRecord.class, ChartEndObjectRecord.class, CatLabRecord.class, DataFormatRecord.class, EndRecord.class, LinkedDataRecord.class, SeriesToChartGroupRecord.class, DataItemRecord.class, ExtendedPivotTableViewFieldsRecord.class, PageItemRecord.class, StreamIDRecord.class, ViewDefinitionRecord.class, ViewFieldsRecord.class, ViewSourceRecord.class};
    private static final Map<Integer, I_RecordCreator> _recordCreatorsById = RecordFactory.recordsToMap(recordClasses);
    private static short[] _allKnownRecordSIDs;

    public static Class<? extends Record> getRecordClass(int sid) {
        I_RecordCreator rc = _recordCreatorsById.get(sid);
        if (rc == null) {
            return null;
        }
        return rc.getRecordClass();
    }

    public static Record[] createRecord(RecordInputStream in) {
        Record record = RecordFactory.createSingleRecord(in);
        if (record instanceof DBCellRecord) {
            return new Record[]{null};
        }
        if (record instanceof RKRecord) {
            return new Record[]{RecordFactory.convertToNumberRecord((RKRecord)record)};
        }
        if (record instanceof MulRKRecord) {
            return RecordFactory.convertRKRecords((MulRKRecord)record);
        }
        return new Record[]{record};
    }

    public static Record createSingleRecord(RecordInputStream in) {
        I_RecordCreator constructor = _recordCreatorsById.get(in.getSid());
        if (constructor == null) {
            return new UnknownRecord(in);
        }
        return constructor.create(in);
    }

    public static NumberRecord convertToNumberRecord(RKRecord rk) {
        NumberRecord num = new NumberRecord();
        num.setColumn(rk.getColumn());
        num.setRow(rk.getRow());
        num.setXFIndex(rk.getXFIndex());
        num.setValue(rk.getRKNumber());
        return num;
    }

    public static NumberRecord[] convertRKRecords(MulRKRecord mrk) {
        NumberRecord[] mulRecs = new NumberRecord[mrk.getNumColumns()];
        for (int k = 0; k < mrk.getNumColumns(); ++k) {
            NumberRecord nr = new NumberRecord();
            nr.setColumn((short)(k + mrk.getFirstColumn()));
            nr.setRow(mrk.getRow());
            nr.setXFIndex(mrk.getXFAt(k));
            nr.setValue(mrk.getRKNumberAt(k));
            mulRecs[k] = nr;
        }
        return mulRecs;
    }

    public static BlankRecord[] convertBlankRecords(MulBlankRecord mbk) {
        BlankRecord[] mulRecs = new BlankRecord[mbk.getNumColumns()];
        for (int k = 0; k < mbk.getNumColumns(); ++k) {
            BlankRecord br = new BlankRecord();
            br.setColumn((short)(k + mbk.getFirstColumn()));
            br.setRow(mbk.getRow());
            br.setXFIndex(mbk.getXFAt(k));
            mulRecs[k] = br;
        }
        return mulRecs;
    }

    public static short[] getAllKnownRecordSIDs() {
        if (_allKnownRecordSIDs == null) {
            short[] results = new short[_recordCreatorsById.size()];
            int i = 0;
            for (Integer sid : _recordCreatorsById.keySet()) {
                results[i++] = sid.shortValue();
            }
            Arrays.sort(results);
            _allKnownRecordSIDs = results;
        }
        return (short[])_allKnownRecordSIDs.clone();
    }

    private static Map<Integer, I_RecordCreator> recordsToMap(Class<? extends Record>[] records) {
        HashMap<Integer, I_RecordCreator> result = new HashMap<Integer, I_RecordCreator>();
        HashSet<Class<? extends Record>> uniqueRecClasses = new HashSet<Class<? extends Record>>(records.length * 3 / 2);
        for (Class<? extends Record> recClass : records) {
            short sid;
            if (!Record.class.isAssignableFrom(recClass)) {
                throw new RuntimeException("Invalid record sub-class (" + recClass.getName() + ")");
            }
            if (Modifier.isAbstract(recClass.getModifiers())) {
                throw new RuntimeException("Invalid record class (" + recClass.getName() + ") - must not be abstract");
            }
            if (!uniqueRecClasses.add(recClass)) {
                throw new RuntimeException("duplicate record class (" + recClass.getName() + ")");
            }
            try {
                sid = recClass.getField("sid").getShort(null);
            }
            catch (Exception illegalArgumentException) {
                throw new RecordFormatException("Unable to determine record types");
            }
            Integer key = sid;
            if (result.containsKey(key)) {
                Class<? extends Record> prevClass = ((I_RecordCreator)result.get(key)).getRecordClass();
                throw new RuntimeException("duplicate record sid 0x" + Integer.toHexString(sid).toUpperCase(Locale.ROOT) + " for classes (" + recClass.getName() + ") and (" + prevClass.getName() + ")");
            }
            result.put(key, RecordFactory.getRecordCreator(recClass));
        }
        return result;
    }

    private static I_RecordCreator getRecordCreator(Class<? extends Record> recClass) {
        try {
            Constructor<? extends Record> constructor = recClass.getConstructor(CONSTRUCTOR_ARGS);
            return new ReflectionConstructorRecordCreator(constructor);
        }
        catch (NoSuchMethodException constructor) {
            try {
                Method m = recClass.getDeclaredMethod("create", CONSTRUCTOR_ARGS);
                return new ReflectionMethodRecordCreator(m);
            }
            catch (NoSuchMethodException e) {
                throw new RuntimeException("Failed to find constructor or create method for (" + recClass.getName() + ").");
            }
        }
    }

    public static List<Record> createRecords(InputStream in) throws RecordFormatException {
        Record record;
        ArrayList<Record> records = new ArrayList<Record>(512);
        RecordFactoryInputStream recStream = new RecordFactoryInputStream(in, true);
        while ((record = recStream.nextRecord()) != null) {
            records.add(record);
        }
        return records;
    }

    private static final class ReflectionMethodRecordCreator
    implements I_RecordCreator {
        private final Method _m;

        public ReflectionMethodRecordCreator(Method m) {
            this._m = m;
        }

        @Override
        public Record create(RecordInputStream in) {
            Object[] args = new Object[]{in};
            try {
                return (Record)this._m.invoke(null, args);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                throw new RecordFormatException("Unable to construct record instance", e.getTargetException());
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._m.getDeclaringClass();
        }
    }

    private static final class ReflectionConstructorRecordCreator
    implements I_RecordCreator {
        private final Constructor<? extends Record> _c;

        public ReflectionConstructorRecordCreator(Constructor<? extends Record> c) {
            this._c = c;
        }

        @Override
        public Record create(RecordInputStream in) {
            Object[] args = new Object[]{in};
            try {
                return this._c.newInstance(args);
            }
            catch (IllegalAccessException | IllegalArgumentException | InstantiationException e) {
                throw new RuntimeException(e);
            }
            catch (InvocationTargetException e) {
                Throwable t = e.getTargetException();
                if (t instanceof RecordFormatException) {
                    throw (RecordFormatException)t;
                }
                if (t instanceof EncryptedDocumentException) {
                    throw (EncryptedDocumentException)t;
                }
                throw new RecordFormatException("Unable to construct record instance", t);
            }
        }

        @Override
        public Class<? extends Record> getRecordClass() {
            return this._c.getDeclaringClass();
        }
    }

    private static interface I_RecordCreator {
        public Record create(RecordInputStream var1);

        public Class<? extends Record> getRecordClass();
    }
}

