/** Copyright 2016 - 2021 Martin Mauch (@nightscape)
  *
  * Licensed under the Apache License, Version 2.0 (the "License");
  * you may not use this file except in compliance with the License.
  * You may obtain a copy of the License at
  *
  *     http://www.apache.org/licenses/LICENSE-2.0
  *
  * Unless required by applicable law or agreed to in writing, software
  * distributed under the License is distributed on an "AS IS" BASIS,
  * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
  * See the License for the specific language governing permissions and
  * limitations under the License.
  */
package com.crealytics.spark.v2.excel

import org.apache.spark.sql.catalyst.OrderedFilters
import org.apache.spark.sql.catalyst.StructFilters
import org.apache.spark.sql.sources
import org.apache.spark.sql.types.StructType

/** Wrapping the API change between spark 3.0 vs 3.1 */
class ExcelFilters(filters: Seq[sources.Filter], requiredSchema: StructType)
    extends OrderedFilters(filters, requiredSchema) {}

object ExcelFilters {
  def pushedFilters(filters: Array[sources.Filter], schema: StructType): Array[sources.Filter] =
    StructFilters.pushedFilters(filters, schema)
}
