/*
 * Decompiled with CFR 0.152.
 */
package com.crealytics.spark.v2.excel;

import com.crealytics.spark.v2.excel.DataLocator;
import com.crealytics.spark.v2.excel.DataLocator$;
import com.crealytics.spark.v2.excel.ExcelHelper$;
import com.crealytics.spark.v2.excel.ExcelOptions;
import com.crealytics.spark.v2.excel.PlainNumberFormat$;
import java.io.InputStream;
import java.io.Serializable;
import java.net.URI;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataInputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.SeqLike;
import scala.collection.TraversableLike;
import scala.collection.immutable.MapLike;
import scala.collection.immutable.Set;
import scala.collection.immutable.Vector;
import scala.collection.immutable.Vector$;
import scala.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.util.Try$;
import shadeio.poi.ss.SpreadsheetVersion;
import shadeio.poi.ss.usermodel.Cell;
import shadeio.poi.ss.usermodel.CellType;
import shadeio.poi.ss.usermodel.DataFormatter;
import shadeio.poi.ss.usermodel.Workbook;
import shadeio.poi.ss.usermodel.WorkbookFactory;
import shadeio.poi.ss.util.AreaReference;
import shadeio.poi.ss.util.CellReference;

@ScalaSignature(bytes="\u0006\u0001\u0005=a\u0001B\u0007\u000f\u0001eA\u0001\u0002\t\u0001\u0003\u0002\u0003\u0006I!\t\u0005\u0006K\u0001!\tA\n\u0005\tS\u0001A)\u0019!C\u0005U!)\u0011\b\u0001C\u0001u!)1\n\u0001C\u0001\u0019\")1\r\u0001C\u0001I\")1\u000f\u0001C\u0001i\")\u0001\u0010\u0001C\u0001s\u001e9\u0011\u0011\u0001\b\t\u0002\u0005\raAB\u0007\u000f\u0011\u0003\t)\u0001\u0003\u0004&\u0015\u0011\u0005\u0011q\u0001\u0005\b\u0003\u0013QA\u0011AA\u0006\u0005-)\u0005pY3m\u0011\u0016d\u0007/\u001a:\u000b\u0005=\u0001\u0012!B3yG\u0016d'BA\t\u0013\u0003\t1(G\u0003\u0002\u0014)\u0005)1\u000f]1sW*\u0011QCF\u0001\u000bGJ,\u0017\r\\=uS\u000e\u001c(\"A\f\u0002\u0007\r|Wn\u0001\u0001\u0014\u0005\u0001Q\u0002CA\u000e\u001f\u001b\u0005a\"\"A\u000f\u0002\u000bM\u001c\u0017\r\\1\n\u0005}a\"AB!osJ+g-A\u0004paRLwN\\:\u0011\u0005\t\u001aS\"\u0001\b\n\u0005\u0011r!\u0001D#yG\u0016dw\n\u001d;j_:\u001c\u0018A\u0002\u001fj]&$h\b\u0006\u0002(QA\u0011!\u0005\u0001\u0005\u0006A\t\u0001\r!I\u0001\u000eI\u0006$\u0018MR8s[\u0006$H/\u001a:\u0016\u0003-\u0002\"\u0001L\u001c\u000e\u00035R!AL\u0018\u0002\u0013U\u001cXM]7pI\u0016d'B\u0001\u00192\u0003\t\u00198O\u0003\u00023g\u0005\u0019\u0001o\\5\u000b\u0005Q*\u0014AB1qC\u000eDWMC\u00017\u0003\ry'oZ\u0005\u0003q5\u0012Q\u0002R1uC\u001a{'/\\1ui\u0016\u0014\u0018aE:bM\u0016\u001cU\r\u001c7TiJLgn\u001a,bYV,GCA\u001eG!\ta4I\u0004\u0002>\u0003B\u0011a\bH\u0007\u0002\u007f)\u0011\u0001\tG\u0001\u0007yI|w\u000e\u001e \n\u0005\tc\u0012A\u0002)sK\u0012,g-\u0003\u0002E\u000b\n11\u000b\u001e:j]\u001eT!A\u0011\u000f\t\u000b\u001d#\u0001\u0019\u0001%\u0002\t\r,G\u000e\u001c\t\u0003Y%K!AS\u0017\u0003\t\r+G\u000e\\\u0001\fO\u0016$xk\u001c:lE>|7\u000eF\u0002N!f\u0003\"\u0001\f(\n\u0005=k#\u0001C,pe.\u0014wn\\6\t\u000bE+\u0001\u0019\u0001*\u0002\t\r|gN\u001a\t\u0003'^k\u0011\u0001\u0016\u0006\u0003#VS!AV\u001a\u0002\r!\fGm\\8q\u0013\tAFKA\u0007D_:4\u0017nZ;sCRLwN\u001c\u0005\u00065\u0016\u0001\raW\u0001\u0004kJL\u0007C\u0001/b\u001b\u0005i&B\u00010`\u0003\rqW\r\u001e\u0006\u0002A\u0006!!.\u0019<b\u0013\t\u0011WLA\u0002V%&\u000bqaZ3u%><8\u000fF\u0002fcJ\u00042AZ6o\u001d\t9\u0017N\u0004\u0002?Q&\tQ$\u0003\u0002k9\u00059\u0001/Y2lC\u001e,\u0017B\u00017n\u0005!IE/\u001a:bi>\u0014(B\u00016\u001d!\r1w\u000eS\u0005\u0003a6\u0014aAV3di>\u0014\b\"B)\u0007\u0001\u0004\u0011\u0006\"\u0002.\u0007\u0001\u0004Y\u0016AD4fi\u000e{G.^7o\u001d\u0006lWm\u001d\u000b\u0003kZ\u00042AZ8<\u0011\u00159x\u00011\u0001o\u0003!1\u0017N]:u%><\u0018A\u00059beN,GMU1oO\u0016\fE\r\u001a:fgN$\u0012A\u001f\t\u0003wzl\u0011\u0001 \u0006\u0003{>\nA!\u001e;jY&\u0011q\u0010 \u0002\u000e\u0003J,\u0017MU3gKJ,gnY3\u0002\u0017\u0015C8-\u001a7IK2\u0004XM\u001d\t\u0003E)\u0019\"A\u0003\u000e\u0015\u0005\u0005\r\u0011!B1qa2LHcA\u0014\u0002\u000e!)\u0001\u0005\u0004a\u0001C\u0001")
public class ExcelHelper {
    private DataFormatter dataFormatter;
    private final ExcelOptions options;
    private volatile boolean bitmap$0;

    public static ExcelHelper apply(ExcelOptions excelOptions) {
        return ExcelHelper$.MODULE$.apply(excelOptions);
    }

    /*
     * WARNING - void declaration
     */
    private DataFormatter dataFormatter$lzycompute() {
        ExcelHelper excelHelper = this;
        synchronized (excelHelper) {
            if (!this.bitmap$0) {
                void var2_2;
                DataFormatter r = new DataFormatter();
                if (this.options.usePlainNumberFormat()) {
                    PlainNumberFormat$ plainNumberFormat = PlainNumberFormat$.MODULE$;
                    r.addFormat("General", plainNumberFormat);
                    r.addFormat("@", plainNumberFormat);
                }
                this.dataFormatter = var2_2;
                this.bitmap$0 = true;
            }
        }
        return this.dataFormatter;
    }

    private DataFormatter dataFormatter() {
        return !this.bitmap$0 ? this.dataFormatter$lzycompute() : this.dataFormatter;
    }

    public String safeCellStringValue(Cell cell) {
        String string;
        CellType cellType = cell.getCellType();
        boolean bl = ((Object)((Object)CellType.BLANK)).equals((Object)cellType) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType);
        if (bl) {
            string = "";
        } else if (((Object)((Object)CellType.STRING)).equals((Object)cellType)) {
            string = cell.getStringCellValue();
        } else if (((Object)((Object)CellType.FORMULA)).equals((Object)cellType)) {
            CellType cellType2 = cell.getCachedFormulaResultType();
            boolean bl2 = ((Object)((Object)CellType.BLANK)).equals((Object)cellType2) ? true : ((Object)((Object)CellType._NONE)).equals((Object)cellType2);
            String string2 = bl2 ? "" : (((Object)((Object)CellType.ERROR)).equals((Object)cellType2) ? cell.getCellFormula() : (((Object)((Object)CellType.STRING)).equals((Object)cellType2) ? cell.getStringCellValue() : (((Object)((Object)CellType.NUMERIC)).equals((Object)cellType2) ? Double.toString(cell.getNumericCellValue()) : this.dataFormatter().formatCellValue(cell))));
            string = string2;
        } else {
            string = this.dataFormatter().formatCellValue(cell);
        }
        return string;
    }

    public Workbook getWorkbook(Configuration conf, URI uri) {
        Workbook workbook;
        try (FSDataInputStream ins = FileSystem.get((URI)uri, (Configuration)conf).open(new Path(uri));){
            Workbook workbook2;
            Option<String> option = this.options.workbookPassword();
            if (None$.MODULE$.equals(option)) {
                workbook2 = WorkbookFactory.create((InputStream)ins);
            } else if (option instanceof Some) {
                Some some = (Some)option;
                String password = (String)some.value();
                workbook2 = WorkbookFactory.create((InputStream)ins, password);
            } else {
                throw new MatchError(option);
            }
            workbook = workbook2;
        }
        return workbook;
    }

    public Iterator<Vector<Cell>> getRows(Configuration conf, URI uri) {
        Iterator<Vector<Cell>> iterator;
        DataLocator excelReader = DataLocator$.MODULE$.apply(this.options);
        try (Workbook workbook = this.getWorkbook(conf, uri);){
            iterator = excelReader.readFrom(workbook);
        }
        return iterator;
    }

    public Vector<String> getColumnNames(Vector<Cell> firstRow) {
        Vector vector;
        Vector rowNumColumn;
        Vector vector2 = rowNumColumn = this.options.columnNameOfRowNumber().isDefined() ? (Vector)package$.MODULE$.Vector().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{(String)this.options.columnNameOfRowNumber().get()})) : package$.MODULE$.Vector().empty();
        if (this.options.header()) {
            Vector headerNames = (Vector)firstRow.map((Function1 & Serializable & scala.Serializable)x$1 -> this.dataFormatter().formatCellValue((Cell)x$1), Vector$.MODULE$.canBuildFrom());
            Vector nonNullHeaderNames = (Vector)headerNames.filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$2(x$1)));
            Set duplicates = ((MapLike)nonNullHeaderNames.groupBy((Function1 & Serializable & scala.Serializable)x -> (String)Predef$.MODULE$.identity(x)).filter((Function1 & Serializable & scala.Serializable)x$2 -> BoxesRunTime.boxToBoolean((boolean)ExcelHelper.$anonfun$getColumnNames$4(x$2)))).keySet();
            vector = (Vector)((TraversableLike)firstRow.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map(arg_0 -> ExcelHelper.$anonfun$getColumnNames$5(this, duplicates, arg_0), Vector$.MODULE$.canBuildFrom());
        } else {
            vector = (Vector)((TraversableLike)firstRow.zipWithIndex(Vector$.MODULE$.canBuildFrom())).map((Function1 & Serializable & scala.Serializable)x0$2 -> {
                Tuple2 tuple2 = x0$2;
                if (tuple2 == null) {
                    throw new MatchError((Object)tuple2);
                }
                int index = tuple2._2$mcI$sp();
                String string = new StringBuilder(2).append("_c").append(index).toString();
                return string;
            }, Vector$.MODULE$.canBuildFrom());
        }
        Vector dataColumns = vector;
        return (Vector)rowNumColumn.$plus$plus((GenTraversableOnce)dataColumns, Vector$.MODULE$.canBuildFrom());
    }

    public AreaReference parsedRangeAddress() {
        return (AreaReference)Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> {
            CellReference cellRef = new CellReference($this.options.dataAddress());
            return new AreaReference(cellRef, new CellReference(cellRef.getSheetName(), SpreadsheetVersion.EXCEL2007.getLastRowIndex(), SpreadsheetVersion.EXCEL2007.getLastColumnIndex(), false, false), SpreadsheetVersion.EXCEL2007);
        }).getOrElse((Function0 & Serializable & scala.Serializable)() -> new AreaReference($this.options.dataAddress(), SpreadsheetVersion.EXCEL2007));
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$2(String x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ boolean $anonfun$getColumnNames$4(Tuple2 x$2) {
        return ((SeqLike)x$2._2()).size() > 1;
    }

    /*
     * Unable to fully structure code
     */
    public static final /* synthetic */ String $anonfun$getColumnNames$5(ExcelHelper $this, Set duplicates$1, Tuple2 x0$1) {
        block3: {
            block2: {
                var4_3 = x0$1;
                if (var4_3 == null) break block2;
                cell = (Cell)var4_3._1();
                index = var4_3._2$mcI$sp();
                value = $this.dataFormatter().formatCellValue(cell);
                v0 = cellType = cell.getCellType();
                var9_8 = CellType.ERROR;
                if (!(v0 == null ? var9_8 != null : v0.equals((Object)var9_8) == false)) ** GOTO lbl-1000
                v1 = cellType;
                var10_9 = CellType.BLANK;
                if (!(v1 == null ? var10_9 != null : v1.equals((Object)var10_9) == false)) ** GOTO lbl-1000
                v2 = cellType;
                var11_10 = CellType._NONE;
                if (!(v2 == null ? var11_10 != null : v2.equals((Object)var11_10) == false) || value.isEmpty()) lbl-1000:
                // 3 sources

                {
                    v3 = new StringBuilder(2).append("_c").append(index).toString();
                } else {
                    v3 = duplicates$1.contains((Object)value) != false ? new StringBuilder(0).append(value).append(index).toString() : value;
                }
                break block3;
            }
            throw new MatchError((Object)var4_3);
        }
        var3_11 = v3;
        return var3_11;
    }

    public ExcelHelper(ExcelOptions options) {
        this.options = options;
    }
}

