/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.poifs.crypt.xor;

import java.io.IOException;
import shadeio.poi.poifs.crypt.ChainingMode;
import shadeio.poi.poifs.crypt.CipherAlgorithm;
import shadeio.poi.poifs.crypt.EncryptionInfo;
import shadeio.poi.poifs.crypt.EncryptionInfoBuilder;
import shadeio.poi.poifs.crypt.HashAlgorithm;
import shadeio.poi.poifs.crypt.xor.XORDecryptor;
import shadeio.poi.poifs.crypt.xor.XOREncryptionHeader;
import shadeio.poi.poifs.crypt.xor.XOREncryptionVerifier;
import shadeio.poi.poifs.crypt.xor.XOREncryptor;
import shadeio.poi.util.LittleEndianInput;

public class XOREncryptionInfoBuilder
implements EncryptionInfoBuilder {
    @Override
    public void initialize(EncryptionInfo info, LittleEndianInput dis) throws IOException {
        info.setHeader(new XOREncryptionHeader());
        info.setVerifier(new XOREncryptionVerifier(dis));
        XORDecryptor dec = new XORDecryptor();
        dec.setEncryptionInfo(info);
        info.setDecryptor(dec);
        XOREncryptor enc = new XOREncryptor();
        enc.setEncryptionInfo(info);
        info.setEncryptor(enc);
    }

    @Override
    public void initialize(EncryptionInfo info, CipherAlgorithm cipherAlgorithm, HashAlgorithm hashAlgorithm, int keyBits, int blockSize, ChainingMode chainingMode) {
        info.setHeader(new XOREncryptionHeader());
        info.setVerifier(new XOREncryptionVerifier());
        XORDecryptor dec = new XORDecryptor();
        dec.setEncryptionInfo(info);
        info.setDecryptor(dec);
        XOREncryptor enc = new XOREncryptor();
        enc.setEncryptionInfo(info);
        info.setEncryptor(enc);
    }
}

