/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xslf.usermodel;

import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.List;
import org.apache.xmlbeans.XmlException;
import org.apache.xmlbeans.XmlOptions;
import org.openxmlformats.schemas.presentationml.x2006.main.CTCommonSlideData;
import org.openxmlformats.schemas.presentationml.x2006.main.CTNotesSlide;
import org.openxmlformats.schemas.presentationml.x2006.main.NotesDocument;
import shadeio.poi.ooxml.POIXMLDocumentPart;
import shadeio.poi.ooxml.POIXMLTypeLoader;
import shadeio.poi.openxml4j.opc.PackagePart;
import shadeio.poi.sl.usermodel.Notes;
import shadeio.poi.xslf.usermodel.XSLFNotesMaster;
import shadeio.poi.xslf.usermodel.XSLFShape;
import shadeio.poi.xslf.usermodel.XSLFSheet;
import shadeio.poi.xslf.usermodel.XSLFTextParagraph;
import shadeio.poi.xslf.usermodel.XSLFTextShape;
import shadeio.poi.xslf.usermodel.XSLFTheme;

public final class XSLFNotes
extends XSLFSheet
implements Notes<XSLFShape, XSLFTextParagraph> {
    private CTNotesSlide _notes;

    XSLFNotes() {
        this._notes = XSLFNotes.prototype();
    }

    XSLFNotes(PackagePart part) throws IOException, XmlException {
        super(part);
        NotesDocument doc = NotesDocument.Factory.parse((InputStream)this.getPackagePart().getInputStream(), (XmlOptions)POIXMLTypeLoader.DEFAULT_XML_OPTIONS);
        this._notes = doc.getNotes();
    }

    private static CTNotesSlide prototype() {
        CTNotesSlide ctNotes = CTNotesSlide.Factory.newInstance();
        CTCommonSlideData cSld = ctNotes.addNewCSld();
        cSld.addNewSpTree();
        return ctNotes;
    }

    public CTNotesSlide getXmlObject() {
        return this._notes;
    }

    @Override
    protected String getRootElementName() {
        return "notes";
    }

    @Override
    public XSLFTheme getTheme() {
        XSLFNotesMaster m = this.getMasterSheet();
        return m != null ? m.getTheme() : null;
    }

    public XSLFNotesMaster getMasterSheet() {
        for (POIXMLDocumentPart p : this.getRelations()) {
            if (!(p instanceof XSLFNotesMaster)) continue;
            return (XSLFNotesMaster)p;
        }
        return null;
    }

    @Override
    public List<List<XSLFTextParagraph>> getTextParagraphs() {
        ArrayList<List<XSLFTextParagraph>> tp = new ArrayList<List<XSLFTextParagraph>>();
        for (XSLFShape sh : super.getShapes()) {
            if (!(sh instanceof XSLFTextShape)) continue;
            XSLFTextShape txt = (XSLFTextShape)sh;
            tp.add(txt.getTextParagraphs());
        }
        return tp;
    }

    @Override
    String mapSchemeColor(String schemeColor) {
        return this.mapSchemeColor(this._notes.getClrMapOvr(), schemeColor);
    }
}

