/*
 * Decompiled with CFR 0.152.
 */
package shadeio.poi.xssf.usermodel;

import shadeio.poi.ss.formula.EvaluationCell;
import shadeio.poi.ss.formula.EvaluationSheet;
import shadeio.poi.ss.formula.FormulaParser;
import shadeio.poi.ss.formula.FormulaType;
import shadeio.poi.ss.formula.ptg.Ptg;
import shadeio.poi.util.Internal;
import shadeio.poi.xssf.usermodel.BaseXSSFEvaluationWorkbook;
import shadeio.poi.xssf.usermodel.XSSFCell;
import shadeio.poi.xssf.usermodel.XSSFEvaluationCell;
import shadeio.poi.xssf.usermodel.XSSFEvaluationSheet;
import shadeio.poi.xssf.usermodel.XSSFSheet;
import shadeio.poi.xssf.usermodel.XSSFWorkbook;

@Internal
public final class XSSFEvaluationWorkbook
extends BaseXSSFEvaluationWorkbook {
    private XSSFEvaluationSheet[] _sheetCache;

    public static XSSFEvaluationWorkbook create(XSSFWorkbook book) {
        if (book == null) {
            return null;
        }
        return new XSSFEvaluationWorkbook(book);
    }

    private XSSFEvaluationWorkbook(XSSFWorkbook book) {
        super(book);
    }

    @Override
    public void clearAllCachedResultValues() {
        super.clearAllCachedResultValues();
        this._sheetCache = null;
    }

    @Override
    public int getSheetIndex(EvaluationSheet evalSheet) {
        XSSFSheet sheet = ((XSSFEvaluationSheet)evalSheet).getXSSFSheet();
        return this._uBook.getSheetIndex(sheet);
    }

    @Override
    public EvaluationSheet getSheet(int sheetIndex) {
        if (this._sheetCache == null) {
            int numberOfSheets = this._uBook.getNumberOfSheets();
            this._sheetCache = new XSSFEvaluationSheet[numberOfSheets];
            for (int i = 0; i < numberOfSheets; ++i) {
                this._sheetCache[i] = new XSSFEvaluationSheet(this._uBook.getSheetAt(i));
            }
        }
        if (sheetIndex < 0 || sheetIndex >= this._sheetCache.length) {
            this._uBook.getSheetAt(sheetIndex);
        }
        return this._sheetCache[sheetIndex];
    }

    @Override
    public Ptg[] getFormulaTokens(EvaluationCell evalCell) {
        XSSFCell cell = ((XSSFEvaluationCell)evalCell).getXSSFCell();
        int sheetIndex = this._uBook.getSheetIndex(cell.getSheet());
        int rowIndex = cell.getRowIndex();
        return FormulaParser.parse(cell.getCellFormula(this), this, FormulaType.CELL, sheetIndex, rowIndex);
    }
}

